/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdExternal.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 95/05/11 22:06:30 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Commands to allow the user to customize the pop-up menu.
 *
 ***************************************************************************/
#ifndef CMDUSERMENU_H
#define CMDUSERMENU_H

#include "Command.h"


// The following use USER_MENU_ADD, USER_MENU_LIST

// text callback routine for 'user'
extern int text_cmd_user(int, char **, CommandQueue *, int);


////////////////////// add a new user menu item
class CmdUserMenuAdd : public Command {
public:
  // types of menu items which can be added
  enum MenuItems { MENU_MENU, MENU_ITEM, MENU_SEP, MENU_SUBITEM, MENU_SUBSEP,
			MENU_KEY, MENU_ITEM_TOTAL };

private:
  // type of item to add
  int itemType;

  // menu/item name being added/changed
  char *menuName;

  // if adding an item to a submenu, the name of the item to add
  char *subItemName;

  // if adding an item, command text
  char *itemCmd;

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  // several constructors; first arg is type of item, rest are needed strings
  CmdUserMenuAdd(char *, int = -1);
  CmdUserMenuAdd(char *, char *, int = -1);
  CmdUserMenuAdd(char *, char *, char *, int = -1);
  CmdUserMenuAdd(char *, char *, char *, char *, int = -1);

  // destructor: free up string storage
  virtual ~CmdUserMenuAdd(void);
};


////////////////////// print out current menu or key definitions
class CmdUserMenuPrint : public Command {
public:
  // items which may be printed out
  enum PrintItems { MENU_DATA, KEY_DATA, PRINT_ITEM_TOTAL };

private:
  // which items to print
  int whichItems;

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdUserMenuPrint(char *, int = -1);
};

#endif

