/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdMouse.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 96/03/23 05:00:12 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Commands to control the state of the Mouse object
 *
 ***************************************************************************/

#include <stdlib.h>
#include "CmdMouse.h"
#include "Mouse.h"
#include "CommandQueue.h"
#include "Global.h"
#include "utilities.h"

// The following use MOUSE_MODE

////////////////////////////////////////////////////////////////////
///////////////////////  text processors
////////////////////////////////////////////////////////////////////

// text callback routine for 'mouse'; return TRUE if an error occurs.
int text_cmd_mouse(int argc, char **argv, CommandQueue *cmdQueue, int id) {
  if(argc < 3 || argc > 4)
    return TRUE;

  // the modes are:
  //  ROTATION == 0, ... USER == 6 ; as defined in Mouse.h
  if(!strupncmp(argv[1], "mode", CMDLEN)) {
    int m1;
    while (1) {
      // see if these are string values
      if (!strupncmp(argv[2], "rotate", CMDLEN)) {
	m1 = Mouse::ROTATION; break; 
      }
      if (!strupncmp(argv[2], "translate", CMDLEN)) { 
	m1 = Mouse::TRANSLATION; break; 
      }
      if (!strupncmp(argv[2], "scale", CMDLEN)){ m1 = Mouse::SCALING; break; }
      if (!strupncmp(argv[2], "light", CMDLEN)){ m1 = Mouse::LIGHT; break; }
      if (!strupncmp(argv[2], "pick", CMDLEN)) { m1 = Mouse::PICKING; break; }
      if (!strupncmp(argv[2], "user", CMDLEN)) { m1 = Mouse::USER; break; }

      // not a string so convert to a number
      m1 = atoi(argv[2]);
      break;
    }
    // get the mouse submode, if there is one
    int m2 = (argc > 3 ? atoi(argv[3]) : (-1));
    cmdQueue->append(new CmdMouseMode(m1, m2, id));

  } else
    return TRUE;
    
  // if here, everything worked out ok
  return FALSE;
}



////////////////////// change the current mouse mode ... this command
////////////////////// does not generate an output text command, it is just
////////////////////// used to change the VMD internal state

int CmdMouseMode::do_execute(void) {
  int retval;
  if((retval = (mouse != NULL))) {
    if(mouseMode == Mouse::ROTATION)
      retval = mouse->move_mode(Mouse::ROTATION);
    else if(mouseMode == Mouse::TRANSLATION)
      retval = mouse->move_mode(Mouse::TRANSLATION);
    else if(mouseMode == Mouse::SCALING)
      retval = mouse->move_mode(Mouse::SCALING);
    else if(mouseMode == Mouse::LIGHT)
      retval = mouse->move_mode(Mouse::LIGHT, mouseSetting);
    else if(mouseMode == Mouse::PICKING)
      retval = mouse->move_mode(Mouse::PICKING, mouseSetting);
    else if(mouseMode == Mouse::USER)
      retval = mouse->move_mode(Mouse::USER, mouseSetting);
    else
      retval = FALSE;
  }
  return retval;
}

CmdMouseMode::CmdMouseMode(int mm, int ms, int newUIid)
	: Command(MOUSE_MODE, newUIid) {
  mouseMode = mm;
  mouseSetting = ms;
}


