/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdMenu.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.4 $      $Date: 95/05/11 22:05:50 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *     The menu commands are defined here.  These tell the app to turn a
 * menu on or off; to move a menu; or print the cooordinates of a menu
 * to infoMsg.  A "menu" is a UIObject that has a window.
 *
 ***************************************************************************/
#ifndef CMDMENU_H
#define CMDMENU_H

//// An example of how to move the "main" menu to 12, 50
// commandQueue->addcommand(new CmdMenuMove(uiList->item("main"),12,50))

#include "Command.h"
class UIObject;

// The following uses the Cmdtypes "MENU_SHOW", "MENU_MOVE", and
// "MENU_LOC" from the Command class

// text callback routine for 'menu'
extern int text_cmd_menu(int, char **, CommandQueue *, int);


//////////// turn a menu on/off
class CmdMenuShow : public Command {
public:
  int turnOn;		// if T, turn on; if F, turn off
  int toUIid;		// id of menu to change
  UIObject *menu;	// pointer to menu to change

protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdMenuShow(int changeUIid, int turnon, int fromUIid = -1);
};


//////////// move a menu about
class CmdMenuMove : public Command {
public:
  int x,y;		// the new coordinates
  int toUIid;		// id of menu to change
  UIObject *menu;	// pointer to menu to change

protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdMenuMove(int changeUIid, int newx, int newy, int fromUIid = -1);
};


//////////// print a menu's location
class CmdMenuLoc : public Command {
public:
  int toUIid;		// id of menu to change
  UIObject *menu;	// pointer to menu to change

protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdMenuLoc(int changeUIid, int fromUIid = -1);
};

#endif

