/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdLabel.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.3 $      $Date: 95/05/11 22:05:48 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Command objects used to create, list, delete, or graph labels for measuring
 * geometries.
 *
 ***************************************************************************/
#ifndef CMDLABEL_H
#define CMDLABEL_H

#include "Command.h"
class Geometry;

// The following uses the Cmdtypes LABEL_ADD, LABEL_SHOW, LABEL_LIST,
// LABEL_GRAPH and LABEL_DELETE from the Command class

// text callback routine for 'label'
extern int text_cmd_label(int, char **, CommandQueue *, int);


////////////////////// add a new label 
class CmdLabelAdd : public Command {
private:
  int cat;		// category for the label
  Geometry *geom;	// geometry object to add
  
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  // constructor: category name, # items, item strings
  CmdLabelAdd(char *, int, char **, int UIid = (-1));
};


////////////////////// list the labels in a category
class CmdLabelList : public Command {
private:
  int cat;		// category to list

protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  // constructor: category name
  CmdLabelList(char *, int UIid = (-1));
};


////////////////////// toggle a geometry category on/off
class CmdLabelShow : public Command {
private:
  int cat;		// category to toggle
  int item;		// which item to toggle (if < 0 toggle entire cat.)
  int show;		// if T, turn on; if F, turn off

protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  // constructor: category name, show, item
  CmdLabelShow(char *, int, int, int UIid = (-1));
};


////////////////////// delete the Nth label in a category
class CmdLabelDelete : public Command {
private:
  int cat;		// category to delete from
  int item;		// which item to delete (if < 0 delete all in cat.)

protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  // constructor: category name, item
  CmdLabelDelete(char *, int, int UIid = (-1));
};


////////////////// graph the values for the Nthe label in the given category
class CmdLabelGraph : public Command {
private:
  int cat;		// category to delete from
  int item;		// which item to graph
  char *graphCmd;	// command to execute to graph data; if null or empty,
  			// echo the data to the console
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  // constructor: category name, item
  CmdLabelGraph(char *, int, char *, int UIid = (-1));
};


#endif

