/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CaveRoutines.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1995/05/12 00:39:25 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * routines to get memory from and return memory to the 
 * CAVE shared memory arena
 ***************************************************************************/
#ifndef CAVEROUTINES_H
#define CAVEROUTINES_H

#include <malloc.h>

// extern void *shared_CAVE_memory_arena;

// use the already alloced memory as the memory arena
// source, and amalloc from it
void *malloc_from_CAVE_memory(size_t size);

// return shared memory to the arena
void free_to_CAVE_memory(void *data);

// get a large chunk of memory from the CAVE and
// remember it for future use
void grab_CAVE_memory(int megs);  


// global routines which call the Scene from the CAVE


// set up the graphics, called from CAVEInitApplication
// doesn't do anything
void cave_gl_init_fn(void);

// return the number of cave render processes
// it does: return CAVEConfig->ActiveWalls
int CAVENumRenderProcesses(void);

// clear the screen, if the frame just started
void cave_clear_screen(void);

// call the renderer
// For the first call this just counts the number of
// drawing processes which were started
void cave_renderer(void);

// wait until all the render processes have finished
void cave_block(void);

#endif

