/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CaveDisplayDevice.h,v $
 *      $Author: dalke $        $Locker:  $                $State: Exp $
 *      $Revision: 1.8 $      $Date: 1996/03/24 07:07:20 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * a CAVE specific display device for VMD
 ***************************************************************************/
#ifndef CAVEDISPLAYDEVICE_H
#define CAVEDISPLAYDEVICE_H

#include "GLRenderer.h"
#include "Inform.h"


class CaveDisplayDevice : public GLRenderer {

private:
  // have we initialized the graphics yet?
  int doneGLInit;

  // set up the graphics on the seperate CAVE displays
  void cave_gl_init_fn(void);
  
public:
  // constructor and destructor
  CaveDisplayDevice(void);
  virtual ~CaveDisplayDevice(void);
  
  // whether a button is currently pressed
  virtual int button_down(int);

  // cannot change to stereo mode
  virtual void set_stereo_mode(int = 0);
  
  // routines to prepare, draw, and finish, some done by the CAVE
  virtual int prepare2D(int);
  virtual int prepare3D(int);
  virtual void clear(void);
  
  // special render routine to check for graphics initialization
  virtual void render(void *);

};

#endif

