/**********************************************************************
 *         Copyright (C) 1995  The Board of Trustees of               *
 *                             the University of Illinois             *
 *                                                                    *
 *  This file is part of the RAPP software package, a library and     *
 *  associated programs for coordinating client/server applications.  *
 *                                                                    *
 **********************************************************************/

/* rapp.h: Main header file for RAPP software.
 *
 * Rick Kufrin <r-kufrin@uiuc.edu>
 * National Center for Supercomputing Applications
 * May, 1995
 * 
 */

#include <stdio.h>

#ifndef _RAPP_H
#define _RAPP_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#include <rapp_types.h>
#include <rapp_errno.h>

/* RAPP RPC declarations */
#include <rappd.h>

#ifdef HAVE_VFORK
#define FORK vfork
#else
#define FORK fork
#endif

/*
 * RAPP user functions
 */


/* Client functions */

int rapp_init(void);

rapp_client_handle_t
rapp_exec_and_connect(char *host, char *user, 
		      char *unix_pass, char *rapp_pass,
		      rapp_optlist_t *optlist,
		      int (*recvStatic)(rapp_active_socket_t *, void *),
		      int (*sendStatic)(rapp_active_socket_t *, void *),
		      void *static_data, void *dynamic_data,
		      int xfer_interval,
		      char *consumer_prog,
		      int (*memCalc)(void *),
		      int (*mapShmem)(void *, void *, shmaddr_t));

int
rapp_exec(char *host, char *user, char *unix_pass, char *rapp_pass,
	  rapp_optlist_t *optlist);

rapp_client_handle_t
rapp_connect(char *host, int port, char *rapp_pass,
	     int (*recvStatic)(rapp_active_socket_t *, void *),
	     int (*sendStatic)(rapp_active_socket_t *, void *),
	     void *static_data, void *dynamic_data,
	     int xfer_interval,
	     char *consumer_prog,
	     int (*memCalc)(void *),
	     int (*mapShmem)(void *, void *, shmaddr_t));

int rapp_set_opt(rapp_optlist_t *optlist, char *key, char *val);
int rapp_set_app(rapp_optlist_t *optlist, char *exe);
int rapp_set_daemon(rapp_optlist_t *optlist, char *daemon);
int rapp_set_cwd(rapp_optlist_t *optlist, char *cwd);
int rapp_update(rapp_client_handle_t handle);
int rapp_probe(rapp_client_handle_t handle);
int rapp_freebuf(rapp_client_handle_t handle);

/*
 * RAPP standard commands
 */
int rapp_kill(rapp_client_handle_t handle);
int rapp_disconnect(rapp_client_handle_t handle);
int rapp_set_xfer_interval(rapp_client_handle_t handle, int new_interval);

/*
 * RAPP user-defined command signaler
 */
int rapp_begin_user_command(rapp_client_handle_t handle, int tag);

/*
 * RAPP memory management routine
 */
void rapp_optlist_dealloc(rapp_optlist_t *optlist);

/*
 * RAPP data transfer functions
 */

int rapp_send(rapp_active_socket_t *sock, int tag, void *buf,
	      int bytes, rapp_datatype_t type);
int rapp_recv(rapp_active_socket_t *sock, int *tag, void *buf,
	      rapp_datatype_t type);

/*
 * RAPP RPC routines
 */
rapp_proglist_t rapp_available_apps(char *host);
rapp_joblist_t rapp_ps(char *host, char *user);
rapp_optlist_t *rapp_get_usage(char *host, char *prog);

/*
 * "Generic" function
 */
int rapp_is_executable(char *);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _RAPP_H */
