#########################################################################
#                                                                       #
#            (C) Copyright 1995 The Board of Trustees of the            #
#                        University of Illinois                         #
#                         All Rights Reserved                           #
#                                                                       #
#########################################################################

# This is part of the VMD installation.
# For more information about VMD, see http://www.ks.uiuc.edu/Research/vmd

# install the "core" vmd/tcl procedures and variables

# catch ^C (SIGINT) to prevent VMD from dying when I stop a Tcl script
signal error SIGINT

# rename the Tcl commands that VMD overrides
rename wait tclx_wait

# default directory locations
if {![info exists env(VMDDIR)]} {
    set env(VMDDIR) /usr/local/lib/vmd
}
if {![info exists env(TMPDIR)]} {
    set env(TMPDIR) /usr/tmp
}

# set the autoloading functions
set auto_path $env(VMDDIR)/scripts/tcl
lappend auto_path $env(VMDDIR)/scripts/tclX
lappend auto_path $env(VMDDIR)/scripts/dp
lappend auto_path $env(VMDDIR)/scripts/vmd


# initialize the vmd_mouse_mode and vmd_mouse_submode variables
set vmd_mouse_mode rotate
set vmd_mouse_submode -1

# some things are NOT autoloaded since that overrides the 
# definitions overridden (for performance reasons) in C++

source $env(VMDDIR)/scripts/vmd/vectors.tcl
source $env(VMDDIR)/scripts/vmd/atomselect.tcl

# the ones that are safe to autoload are ...
#  basic.tcl
#  draw.tcl
#  fit.tcl  (barely, but Mouse.C can handle not knowing some variables)
#  measure.tcl
#  stride.tcl
#  external.tcl

# the index is made with:
# auto_mkindex . \
#     {{basic,draw,fit,measure,stride,external,popup,save_state}.tcl}

#######################################
#  This uses the Perl script 'url_get' to load a structure available
# from a URL
# It cannot be autoloaded since VMD calls 'vmd_mol_urlload'
# directly (w/o using one of the Eval commands)
proc vmd_mol_urlload {url} {
    global env
    # get the full path to the executable $VMDDIR/lib/script/vmd/url_get
    set execname $env(VMDDIR) 
    append execname /scripts/vmd/url_get

    # get the file name in which to save
    set filename $env(TMPDIR)
    append filename "/urlload"
    set filename [unique_file $filename]
    # and call the program
    exec $execname $url > $filename
    return $filename
}

