# some of the functions available from the popup mouse are 
# implemented here

# last file name used (the default "save" file)
set vmd_script_filename "vmdsave.vmd"

# graphical version of save_state 
proc vmd_save_state {} {
    global vmd_script_filename
    set filename [feedback filename "Save the current VMD configuration into" \
		      "" "*.vmd" $vmd_script_filename]
    save_state $filename
    set vmd_script_filename [file tail $filename]
    return
}

# graphical version of save_state, quit at the end
proc vmd_save_state_q {} {
    set filename [feedback filename "Save the current VMD configuration into" \
		      "" "*.vmd" "vmdsave.vmd"]
    save_state $filename
    quit
}


# ask for a script to play, and source it
proc vmd_play_file {} {
    global vmd_script_filename
    set filename [feedback filename "Enter the name of a VMD script file" \
		      "" "*.vmd" $vmd_script_filename]
    source $filename
    set vmd_script_filename [file tail $filename]
    return
}
