# the ancillary "atomselect" functions

proc vmd_atomselect_moveby {sel vect} {
    set coords {}
    foreach v [$sel get {x y z}] {
	set tmp [vecadd $v $vect]
	lappend coords $tmp
    }
    $sel set {x y z} $coords
}

proc vmd_atomselect_lmoveby {sel vectlist} {
    if {[llength $vectlist] != [$sel num]} {
	error [list atomselect: lmoveby: [llength $vectlist] \
	       vectors in list but [$sel num] in selection $sel]
    }
    set coords {}
    foreach v [$sel get {x y z}] {
	lappend coords [vecadd $v [lvarpop vectlist]]
    }
    $sel set {x y z} $coords
}

# trivial, but here for completeness
proc vmd_atomselect_moveto {sel vect} {
    $sel set {x y z} [ldup [$sel num] $vect]
}
proc vmd_atomselect_lmoveto {sel vectlist} {
    $sel set {x y z} $vectlist
}

# This applies a 4x4 matrix to each of the coordinates
proc vmd_atomselect_move {sel trans} {
    set coords {}
    foreach coord [$sel get {x y z}] {
	lappend coords [coordtrans $trans $coord]
    }
    $sel set {x y z} $coords
}


# given a selection, write a PDB file
# by default it writes directly to the screen (/dev/tty)
proc vmd_atomselect_writepdb {sel {filename /dev/tty}} {
    # get the data (returns error if molecule doesn't exist)
    set seldata [$sel get {
	protein index name resname chain resid x y z occupancy beta segname}]

    # open the file (returns error if it couldn't)
    set fileId [open $filename w]

    # and print out the data
    puts $fileId [list REMARK [$sel num] atoms from atomselect writepdb]
    foreach data $seldata {
	if [lindex $data 0] {
	    set cardname "ATOM"
	} else {
	    set cardname "HETATM"
	}
	set index     [expr [lindex $data 1] + 1]
	set name      [lindex $data 2]
	set resname   [lindex $data 3]
	# the resname should end in column 3 (of the four) if < 4 characters
        if {[string length $resname] < 4} {
	    set resname "$resname "
	}
	set chain     [lindex $data 4]
	set resid     [lindex $data 5]
	set x         [lindex $data 6]
	set y         [lindex $data 7]
	set z         [lindex $data 8]
	set occupancy [lindex $data 9]
	set beta      [lindex $data 10]
	set segname   [lindex $data 11]
	puts $fileId [format "%-6s%5d %-4s%1s%-4s%1s%4d%1s   %8.3f%8.3f%8.3f%6.2f%6.2f %3s  %4s" $cardname $index $name " " $resname $chain $resid " " $x $y $z $occupancy $beta "   " $segname]

    }
    puts $fileId END
    close $fileId
}

####### Note quite an "atomselect" term, but close enough to 
# merit being here

# make 'coord' be the center for all the active molecules.  This is
# called from the mouse pull-down menu "center" command item specific
# to a given atom
proc vmd_set_center {coord} {
    foreach mol [molinfo list] {
	if [molinfo $mol get active] {
	    molinfo $mol set center [list $coord]
	}
    }
}

#######
# print information about a given atom
proc vmd_print_atom_info {molid atomid} {
    set sel [atomselect $molid "index $atomid"]
    if {[$sel num] != 1} {
	puts "Error in vmd_print_atom_info '$molid' '$atomid'"
	return
    }
    # get the attributes
    set attr {name type index resname resid chain segname x y z}
    set data [lindex [$sel get $attr] 0]
    foreach x $attr {
	set dat [lvarpop data]
	puts "$x: $dat"
    }
}
