set noderank [parallel noderank]
puts "starting: noderank is $noderank"
set localList ""

proc showTime {commentString} {
  set noderank  [parallel noderank]
  set tsec [clock seconds]
  set tms [clock clicks -milliseconds]
  set ts [clock format $tsec -format %c]
  puts "$commentString Time= $ts   tsec= $tsec tms= $tms Node= $noderank";
}


proc writeCombineGathered {filename dataNameVals dataValNum numFrames glist}  {
  #normally, only node 0 should run this
  global dataValArray
  global contigValArray 
  global contigValNum 
  set noderank  [parallel noderank]
  set nodecount [parallel nodecount]
  showTime "Starting writeCombineGathered\n noderank= $noderank  nodecount= $nodecount"
 
  set dataName(vals) $dataNameVals 
  set currentMol 0



  #variable currentMol
  variable numDataFrames  $numFrames
  #hard code, this version does not handle non-free selection
  set usesFreeSelection 1
  set dataFileVersion "1.4"
  
  set writeDataFile [open $filename w]
  puts $writeDataFile "# VMD Timeline data file"
  puts $writeDataFile "# CREATOR= $::tcl_platform(user)"
  puts $writeDataFile "# MOL_NAME= [molinfo $currentMol get name]"
  puts $writeDataFile "# DATA_TITLE= $dataName(vals)"
  puts $writeDataFile "# FILE_VERSION= $dataFileVersion"
  puts $writeDataFile "# NUM_FRAMES= $numFrames "
  puts $writeDataFile "# NUM_ITEMS= $contigValNum"

  if {$usesFreeSelection} {
    puts $writeDataFile "# FREE_SELECTION= 1"
    puts $writeDataFile "#"
  } else {
    puts $writeDataFile "# FREE_SELECTION= 0"
    puts $writeDataFile "#"
    # XXX this version does not handle non-free selection 
  }

  #next lines only write free-selections

  set frame -1
  for {set contigIndex 0} {$contigIndex<$contigValNum} {incr contigIndex} {
    showTime "In write loop, contigIndex= $contigIndex"
    puts $writeDataFile "freeSelLabel $contigValArray(selLabel,$contigIndex)"
    puts $writeDataFile "freeSelString  $contigValArray(selText,$contigIndex)"
    set listNoderank 0
    #puts "about to loop over glist"
    foreach nodeElem $glist {
    showTime  "Node loop start: listNoderank= $listNoderank, contigIndex=$contigIndex\n"
      set lengthNodeElem [llength $nodeElem]
      showTime "length of nodeElem is $lengthNodeElem"
      set contigPos [expr $contigIndex + 1]
      foreach frameElem $nodeElem {
        #showTime "frameElem= $frameElem"
        set theFrame [lindex $frameElem 0]
        set theVal [lindex $frameElem $contigPos] 
        #showTime "gathered listNoderank= $listNoderank, frameElem= $frameElem,  theVal= $theVal"
        puts $writeDataFile "$theFrame $theVal"
      }
      incr listNoderank
    }     
  }
 
  close $writeDataFile

  showTime "Finishing writeCombineGathered Node $noderank  nodecount= $nodecount"
  return
}

 


proc readSels {currentMol partSelText keyAtomSelString structureFrame selMethod setStructFilename trajectoryFilename selListFilename} {
  #make selections and put them into dataValArray
  #also, put description data about each selection (resid, etc.) into dataValArray
  # structureFrame is trajFrame at which structure is taken
  global dataValArray
  global contigValArray
  global contigValSelList
  global dataValNum
  global contigValNum 
  set contigValNum 0
  set dataValNum 0
   #how to share this?
  set noderank  [parallel noderank]
  set nodecount [parallel nodecount]
  puts "*** first readSels line" 
     #a flat list with the same information as dataValArray(sel,-- )
  showTime "*** Starting readSels  Node $noderank"
  showTime "currentMol= $currentMol   partSelText= >$partSelText<  selMethod= >$selMethod<  keyAtomSelString= $keyAtomSelString  structureFrame= $structureFrame   selMethod= $selMethod"
  showTime "readSels post var print" 
   #tests
   showTime "numframes is [molinfo 0 get numframes]" 
  set ccssSelMethod $selMethod 
  #force anyway for now
  set ccssSelMethod 1
  #start selection/calc insert
  #at this point, no frames are loaded
  # read in the single required frame, structure is not calculated so structure franme is pointless here
  mol addfile $trajectoryFilename first $structureFrame last $structureFrame step 1 waitfor all
  
  if {$ccssSelMethod == 1}  {
   # we will use term 'contig' but for read-in selections, this is really an arbitrary user selection
   showTime "starting segment checks"
   set selListFile [open $selListFilename r]
   set selFileData [read $selListFile]
   close $selListFile  
   set selFileLines [split $selFileData "\n"]
   foreach ll $selFileLines { 
      if {$ll!=""} {
        #allows two formats of selection lists. With and without names
        #selection-text;label-text  <-- semicolon separates
        set entries [split $ll ";"]
        set selPhrase [lindex $entries 0]
        if {[lindex $entries 1]==""} {
          set contigValArray(selLabel,$contigValNum) $selPhrase
        } {
          set contigValArray(selLabel,$contigValNum) [lindex $entries 1]
        }

        
        #assume is a valid selection
        puts "current line is >$ll<"
        set com "atomselect $currentMol \"$selPhrase\""
        puts "command will be >$com<   labelText is $contigValArray(selLabel,$contigValNum)"
        set contigValArray(sel,$contigValNum) [namespace eval :: $com]
        set contigValArray(selText,$contigValNum) $selPhrase
        #test that it worked
        set numcheck [$contigValArray(sel,$contigValNum) num]
        showTime "added contigValArray(sel,$contigValNum) with atoms= $numcheck" 
        incr contigValNum
      }
   }
      
  } else {
    showTime "starting segment checks"
    # unless recalcing secondary structure, this should be changed so only be done once
    #set all $all
    set keyAtomSelString "name CA"
    #override 
    #only protein, since deciding secondary structure

    set atomSel [atomselect $currentMol "$partSelText and $keyAtomSelString"]
    set segList [lsort -unique -dictionary [$atomSel get segid]]
    #XXX can I avoid setting these?
    # $atomSel set beta 0.0
    # $atomSel set occupancy 0.0
    #tlPutsDebug "Just set segList"
    # PDB files do not have segids
    if {[llength $segList] < 1} {
      foreach chain [lsort -unique [$atomSel get chain]] {
          set chainSel [atomselect $currentMol "chain $chain"]
          #XXX altering (admittedly empty) molec data; not good.  Avoid this with an empty-segid-atoms pass below.
          #XXX worse, current approach misses segid-less parts of mixed segid-full and segid-less molecules
          $chainSel set segid $chain
          $chainSel delete
      }
      set segList [lsort -unique -dictionary [$atomSel get segid]]
    } 
    set testCoord [$atomSel get x] 
    #showTime "segList= $segList   testCoord(x)= $testCoord"

    showTime "structureFrame=  $structureFrame"

    # only one frame present
    animate goto 0
    
    mol ssrecalc $currentMol
   
    #read in structure -- 
    source $setStructFilename
 
    foreach seg $segList {
      #note this is not key atom, this is limiting us to protein only, since secondary structure 
 
      set segCASel [atomselect $currentMol "segid $seg and name CA"]
      #if penalty for setting frame, move out of loop
      #tlPutsDebug "segid $seg"
      set ssList [$segCASel get structure]
      #first secondary structure call for whole system will be at structureFrame, determines ss for remainder of run 
      
      #tlPutsDebug $ssList
      set resList [lsort -unique -integer [$segCASel get resid]]
      showTime "ssList= $ssList  resList= $resList"
      set resListLength [llength $resList]
      $segCASel delete

      set id_begin [lindex $resList 0]
      set id_end [expr $id_begin + $resListLength - 1]
      set id_0 $id_begin
      for {set id_i $id_begin} {$id_i <= $id_end} {incr id_i} {
        #do next two lines  mean the unique in resList sort could cause problems with malformed molecs?
        #does this over-depend on perfect sequence of residue numbers?
        set ss_0 [lindex $ssList [expr $id_i - $id_begin]]
        set ss_1 [lindex $ssList [expr $id_i - $id_begin + 1]]
        #tlPutsDebug "id_i = $id_i ss_0 = $ss_0 ss_1 = $ss_1"

          # 
        if {$ss_0 != $ss_1} {
          #store a new contig...

          set com "atomselect $currentMol \"segid $seg and (resid $id_0 to $id_i)\""
          set contigValArray(sel,$contigValNum) [namespace eval :: $com]
          #assume it will contain at least one residue
          set contigValArray(dataValIndexStart,$contigValNum) $dataValNum
          #...and now store the per-residue information it contains... 
          
          showTime  "segid $seg and (resid $id_0 to $id_i)"
                  
          # store raw CC

          #Now get scaled quantity (this is the one we want)

        
          set setList [$contigValArray(sel,$contigValNum) get {name resid chain segname}]
          foreach elem $setList {
            foreach {aName aResid aChain aSegname} $elem {
              #add a new dataValNum
              if {$aName=="CA"} {
                set dataValArray(resid,$dataValNum) $aResid
                set dataValArray(chain,$dataValNum) $aChain
                set dataValArray(segname,$dataValNum) $aSegname
                set contigValArray(dataValIndexEnd,$contigValNum) $dataValNum
                #showTime "set contigValArray(dataValIndexEnd,$contigValNum) to $dataValNum  aResid= $aResid, dataValArray(resid,$dataValNum)= $dataValArray(resid,$dataValNum)"
                incr dataValNum
              }
            } 
              #tlPutsDebuguts "List: name: $aName resid: $aResid chain: $aChain segname: $aSegname"
          }
             

          incr contigValNum

          showTime "new contig made, contigValNum= $contigValNum"
          set id_0 [expr $id_i +1]
        }
      }
    } 
  }

  #end selection/calc insert

  showTime "*** Continuing makeSels  Node $noderank"
 
   #this returns dataValNum 
  #create a selection list array to be passed to the API designed for this
  set contigValSelList ""
  showTime "Node $noderank, before create dataValSelList, contigValNum= $contigValNum"
  for {set contigValIndex 0}  {$contigValIndex < $contigValNum} {incr contigValIndex} {
    showTime "contigValNum= $contigValNum  contigValArray(sel,$contigValIndex)= $contigValArray(sel,$contigValIndex)"
    lappend contigValSelList $contigValArray(sel,$contigValIndex)
  }
  # the seletion command name list is stored in two places, since we needed a new way to present to mdffi cclist -- which is currently a loop over mdffi cc that _emulates_ this.
  showTime "Node $noderank, Done with selections. dataValNum= $dataValNum, contigValNum= $contigValNum"
 
  return $contigValNum 
}

proc makeSels {currentMol partSelText keyAtomSelString structureFrame selMethod setStructFilename trajectoryFilename} {
  #make selections and put them into dataValArray
  #also, put description data about each selection (resid, etc.) into dataValArray
  # structureFrame is trajFrame at which structure is taken
  global dataValArray
  global contigValArray
  global contigValSelList
  global dataValNum
  global contigValNum 
  set contigValNum 0
  set dataValNum 0
   #how to share this?

  set noderank  [parallel noderank]
  set nodecount [parallel nodecount]
  puts "*** first makeSels line" 
     #a flat list with the same information as dataValArray(sel,-- )
  showTime "*** Starting makeSels  Node $noderank"
  showTime "currentMol= $currentMol   partSelText= >$partSelText<  selMethod= >$selMethod<  keyAtomSelString= $keyAtomSelString  structureFrame= $structureFrame   selMethod= $selMethod"
  showTime "makeSels post var print" 
   #tests
   showTime "numframes is [molinfo 0 get numframes]" 
  set ccssSelMethod $selMethod 
  #start selection/calc insert
  #at this point, no frames are loaded
  # read in the required frame
  mol addfile $trajectoryFilename first $structureFrame last $structureFrame step 1 waitfor all

  if {$ccssSelMethod == 1}  {
    puts "Free selection method not yet implemented. Exiting."
    exit
    
  } else {
    showTime "starting segment checks"
    # unless recalcing secondary structure, this should be changed so only be done once
    #set all $all
    set keyAtomSelString "name CA"
    #override 
    #only protein, since deciding secondary structure

    set atomSel [atomselect $currentMol "$partSelText and $keyAtomSelString"]
    set segList [lsort -unique -dictionary [$atomSel get segid]]
    #XXX can I avoid setting these?
    # $atomSel set beta 0.0
    # $atomSel set occupancy 0.0
    #tlPutsDebug "Just set segList"
    # PDB files do not have segids
    if {[llength $segList] < 1} {
      foreach chain [lsort -unique [$atomSel get chain]] {
          set chainSel [atomselect $currentMol "chain $chain"]
          #XXX altering (admittedly empty) molec data; not good.  Avoid this with an empty-segid-atoms pass below.
          #XXX worse, current approach misses segid-less parts of mixed segid-full and segid-less molecules
          $chainSel set segid $chain
          $chainSel delete
      }
      set segList [lsort -unique -dictionary [$atomSel get segid]]
    } 
    set testCoord [$atomSel get x] 
    #showTime "segList= $segList   testCoord(x)= $testCoord"
    #tlPutsDebug "segList: $segList"

    showTime "structureFrame=  $structureFrame"

    # only one frame present
    animate goto 0
    
    mol ssrecalc $currentMol
   
    #read in structure -- 
    source $setStructFilename
 
    foreach seg $segList {
      #note this is not key atom, this is limiting us to protein only, since secondary structure 
 
      set segCASel [atomselect $currentMol "segid $seg and name CA"]
      #if penalty for setting frame, move out of loop
      #tlPutsDebug "segid $seg"
      set ssList [$segCASel get structure]
      #first secondary structure call for whole system will be at structureFrame, determines ss for remainder of run 
      
      #tlPutsDebug $ssList
      set resList [lsort -unique -integer [$segCASel get resid]]
      showTime "ssList= $ssList  resList= $resList"
      set resListLength [llength $resList]
      $segCASel delete

      set id_begin [lindex $resList 0]
      set id_end [expr $id_begin + $resListLength - 1]
      set id_0 $id_begin
      for {set id_i $id_begin} {$id_i <= $id_end} {incr id_i} {
        #tlPutsDebug check2
        #do next two lines  mean the unique in resList sort could cause problems with malformed molecs?
        #does this over-depend on perfect sequence of residue numbers?
        set ss_0 [lindex $ssList [expr $id_i - $id_begin]]
        set ss_1 [lindex $ssList [expr $id_i - $id_begin + 1]]
        #tlPutsDebug "id_i = $id_i ss_0 = $ss_0 ss_1 = $ss_1"

          # 
        if {$ss_0 != $ss_1} {
          #store a new contig...

          set com "atomselect $currentMol \"segid $seg and (resid $id_0 to $id_i)\""
          set contigValArray(sel,$contigValNum) [namespace eval :: $com]
          #assume it will contain at least one residue
          set contigValArray(dataValIndexStart,$contigValNum) $dataValNum
          #...and now store the per-residue information it contains... 
          
          showTime  "segid $seg and (resid $id_0 to $id_i)"

          # in case no overlap at all
          # store raw CC
          # Now get scaled quantity (this is the one we want)

        
          set setList [$contigValArray(sel,$contigValNum) get {name resid chain segname}]
          foreach elem $setList {
            foreach {aName aResid aChain aSegname} $elem {
              #add a new dataValNum
              if {$aName=="CA"} {
                set dataValArray(resid,$dataValNum) $aResid
                set dataValArray(chain,$dataValNum) $aChain
                set dataValArray(segname,$dataValNum) $aSegname
                set contigValArray(dataValIndexEnd,$contigValNum) $dataValNum
                #showTime "set contigValArray(dataValIndexEnd,$contigValNum) to $dataValNum  aResid= $aResid, dataValArray(resid,$dataValNum)= $dataValArray(resid,$dataValNum)"
                incr dataValNum
              }
            } 
          }
             

          incr contigValNum

          showTime "new contig made, contigValNum= $contigValNum"
          set id_0 [expr $id_i +1]
          #tlPutsDebug "id_0 has moved to $id_0"
        }
      }
    } 
  }

  #end selection/calc insert

  showTime "*** Continuing makeSels  Node $noderank"
  set theSel [atomselect $currentMol "$partSelText and $keyAtomSelString"]

  set alist [$theSel get index]
  set alistLength [llength $alist]
  showTime "Node $noderank alistLength= $alistLength"
  #set frameTotal [expr  ($lastAnalysisFrame - $firstAnalysisFrame +1)]
 
 #this returns dataValNum 
  #create a selection list array to be passed to the API designed for this
  set contigValSelList ""
  showTime "Node $noderank, before create dataValSelList, contigValNum= $contigValNum"
  for {set contigValIndex 0}  {$contigValIndex < $contigValNum} {incr contigValIndex} {
    showTime "contigValNum= $contigValNum  contigValArray(sel,$contigValIndex)= $contigValArray(sel,$contigValIndex)"
    lappend contigValSelList $contigValArray(sel,$contigValIndex)
  }
  # the seletion command name list is stored in two places, since we needed a new way to present to mdffi cclist -- which is currently a loop over mdffi cc that _emulates_ this.
  showTime "Node $noderank, Done with selections. alistLength= $alistLength dataValNum= $dataValNum"
 
  return $dataValNum
}

proc mpiCrossCorrFrame { balanceRank userdata} {
  global localList
  global dataValArray 
  global dataValSelList

  global contigValSelList 
  global contigValSelListNum
  global contigValNum
  global contigValArray
   
  set noderank  [parallel noderank]
  set nodecount [parallel nodecount]

  #currently, only one map will be loadd
  set ccMapVolId 0
  set currentMol 0

   showTime "starting mpiCrossCorrFrame, Node $noderank"

  puts "Node $noderank, before testing length of localList"
  set testLength [llength $localList]
  puts "Node $noderank, testLength= $testLength  is length of localList"

    #read userdata
  showTime "about to set userdata"
  set numFrames [lindex $userdata 0] 
   #not using numFrames yet, maybe for tiled vesions
  set dataValNum [lindex $userdata 1] 
  set trajectoryFilename [lindex $userdata 2]
  set setStructFilename [lindex $userdata 3]
  set ccMapRes [lindex $userdata 4]
  set ccMapSpacing [lindex $userdata 5]
  set ccUseMapSpacing [lindex $userdata 6]
  set ccThreshold [lindex $userdata 7]
  set ccUseThreshold [lindex $userdata 8]
  set balanceCount [lindex $userdata 9]
  set targetBalanceCount [lindex $userdata 10]
  set framesPerTask [lindex $userdata 11]
  set remainder [lindex $userdata 12] 

  showTime "done setting userdata"
 

   
  showTime "In mpiCrossCorrFrame:  balanceRank= $balanceRank"
  showTime "Reading from userdata; numFrames= $numFrames, dataValNum= $dataValNum, trajectoryFilename= $trajectoryFilename, setStructFilename= $setStructFilename, ccMapRes= $ccMapRes, ccMapSpacing=  $ccMapSpacing, ccUseMapSpacing= $ccUseMapSpacing, ccThreshold= $ccThreshold, ccUseThreshold= $ccUseThreshold, balanceRank= $balanceRank, balanceCount= $balanceCount, targetBalanceCount= $targetBalanceCount, framesPerTask= $framesPerTask, remainder= $remainder"

  #delete any loaded frames
  animate delete  beg 0 end -1 skip 0 0
  puts "Node $noderank,  frames deleted" 
  set start [expr $balanceRank  * $framesPerTask]
  puts "Node $noderank, balanceRank= $balanceRank, have set start"
  set end   [expr ( ($balanceRank + 1 ) * $framesPerTask ) - 1]
  if {$balanceRank >= $targetBalanceCount} {
    puts "first choice in balanceRank passed, end= $end, numFrames= $numFrames"
    if {$end > [expr $numFrames -1]} { 
      puts "second choice in balanceRank passed, end= $end"
      set end [expr $numFrames - 1]
      puts "have set end after choices"
      puts "Node $noderank, above targetBalanceCount, balanceRank= $balanceRank, targetBalanceCount= $targetBalanceCount, start=$start, end=$end"
    }
  }
  puts "Node $noderank, have chosen for balanceRank"
  puts "start= $start  end= $end, Node $noderank, balanceRank= $balanceRank"
 

  showTime "Node $noderank, about to add frames, start= $start end= $end"
  mol addfile $trajectoryFilename first $start last $end step 1 waitfor all
  puts "Node $noderank, done adding frames"
  puts "Node $noderank, balance $balanceRank, numframes is [molinfo $currentMol get numframes]" 
  #all but currentMol should be passed in.


  #set firstAnalysisFrame 0
  #set lastAnalysisFrame $numFrames 

  showTime "In mpiCrossCorrFrame, Node $noderank, dataValNum= $dataValNum."
  #showTime "Node $noderank, before file add"

 
  #puts "Node $noderank, already have loaded [molinfo top get numframes] frames"

  
 puts "starting loop, Node $noderank, balanceRank= $balanceRank, start=$start, end=$end"
  #make a simple list of the selections, could do this once per job, but is quick

  showTime "Node $noderank, before loop over frames, start= $start, end= $end"
  puts "Node $noderank, before dataVal print line"
 
  for {set theFrame $start} {$theFrame <= $end} {incr theFrame} {
    showTime "in frame loop, theFrame= $theFrame, start= $start, end= $end"
    set loadedFrame [expr $theFrame - $start ]  
    
    for {set contigValIndex 0}  {$contigValIndex < $contigValNum} {incr contigValIndex} {

      ##lappend flist "$resid $chain $segname $start $end" 
      #showTime "Node $noderank, before frame change, dataValIndex $dataValIndex"   
      $contigValArray(sel,$contigValIndex) frame $loadedFrame
      #showTime "Node $noderank, before calc, dataValIndex $dataValIndex"   
      ##showTime "Node $noderank, before lappend, contigValIndex $contigValIndex"   
      #puts "Node $noderank, theVal = $theVal"
      ### lappend flist $theVal
      #checkRangeLimits when inputting later
    }  
    showTime "Node $noderank, before cc call, theFrame= $theFrame loadedFrame= $loadedFrame, ccUseThreshold= $ccUseThreshold"   
    showTime "contigValSelList= $contigValSelList"
    #since there is no mdffi cclist command yet, fake it...
    set ccValList ""
    if {$ccUseThreshold} {
      puts "test 1"
      # tlPutsDebug "yes threshold use, threshold= $ccssThreshold"
      foreach elem $contigValSelList {
        #showTime "start of cc calc loop, elem= $elem"
        if {$ccUseMapSpacing} {
          lappend ccValList [mdffi cc $elem -res $ccMapRes -spacing $ccMapSpacing -mol $currentMol -vol $ccMapVolId ]]
        } else {
          lappend ccValList [mdffi cc $elem -res $ccMapRes -mol $currentMol -vol $ccMapVolId ]]
        }
      }
    } else {
      #showTime "about to run cc calc loop, ccUseThreshold= $ccUseThreshold"
      #tlPutsDebug "no threshold use, threshold= $ccssThreshold"
     showTime "before start of cc calc loop"
      foreach elem $contigValSelList {
        if {$ccUseMapSpacing} {
          #showTime "calc with ccUseMapSpacing= $ccUseMapSpacing"
          lappend ccValList [mdffi cc $elem -res $ccMapRes -spacing $ccMapSpacing -mol $currentMol -vol $ccMapVolId ]
          } else {
            #showTime "calc with ccUseMapSpacing= $ccUseMapSpacing"
            #showTime "time for cc calc, elem= $elem, will run mdffi cc $elem -res $ccMapRes -threshold $ccThreshold -mol $currentMol -vol $ccMapVolId"
            lappend ccValList [mdffi cc $elem -res $ccMapRes -mol $currentMol -vol $ccMapVolId ]
            #showTime "ccValList= $ccValList"
          }
      }
    }

    showTime "Node $noderank, before lappend cclist to flist, theFrame= $theFrame loadedFrame= $loadedFrame"   
    set flist "$theFrame ${ccValList}"  

    set lengthFlist [llength $flist]
    #puts "flist= $flist"
    showTime "Node $noderank, before localList lappend, lengthFlist= $lengthFlist, theFrame= $theFrame loadedFrame= $loadedFrame"   
    lappend localList $flist


    ## debug printing
    ##puts "Node $noderank;  flist: $flist"
    ##puts "Node $noderank;   locallist: $localList"

    #report length of localList
    set theLength [llength $localList]
    showTime "Length of localList is $theLength, Node $noderank. "
  }
}




proc crosscorrCalc {psfFilename dcdFilename volFileName setStructFilename selListFilename structureFrame numFrames  ccMapRes ccMapSpacing ccUseMapSpacing ccThreshold ccUseThreshold targetRunsPerNode maxSelCount outFilename} {
  global dataValNum 
  global localList
  set noderank  [parallel noderank]
  set nodecount [parallel nodecount]
  set start 0
  set end [expr $numFrames - 1]
  
  #not using maxSelCount yet, this version defines selections 
 
  set currentMol 0

  puts "starting crosscorrCalc"
  #XX note that we are not setting start and end frames
  showTime "crosscorrCalc, Node $noderank, before file add"
  mol new $psfFilename first 0 last 0 step 1  waitfor all
  mol addfile $volFileName 0
  #load only 1 frame to do selections with
  #do modulo file reading here if needed

  showTime "Node $noderank, before traj load"

  set trajectoryFilename $dcdFilename
  #mol addfile $trajectoryFilename first $start last $end step 1 waitfor all

  showTime "Node $noderank, loaded [molinfo top get numframes] frames"
 
  # Make work - create apprporiately-sized pieces of work for load balanced run.
  # Here we enumerate frames (later, tiles of residues-or-selections x frames)
  # to analyze  and divide up potential tasks.  Could be work blocks.
  # 
  #set partSelText "all"
  #probably partSelText will not be used here anyway 
  set keyAtomSelString "((all and name CA) or ( (not protein) and  ( (name \"C3\\'\") or (name \"C3\\*\") ) ) or (name BAS) )"
  #this will be overrulled to CA-only for protein only for ss contif structure search

  # make the selections and find description data 
 #this will set the globals dataValArray, contigValArray, contigValSelList, dataValNum,,,,,,,, contigValNum 
 
  set selMethod 1

  #for now, force partSelText (we are assigning sels explicitly)
  set partSelText "all"
 
 # selection method, 
 # 1 = list of user sels  0= find contig secondary structure
 # force 0, contig secondary structure method for now
 ##makeSels $currentMol $partSelText $keyAtomSelString $structureFrame $selMethod $setStructFilename $trajectoryFilename
  puts "In crosscorrCalc, selListFilename=  $selListFilename"


  readSels $currentMol $partSelText $keyAtomSelString $structureFrame $selMethod $setStructFilename $trajectoryFilename $selListFilename
  

  puts "writing to userdata; trajectoryFilename is $trajectoryFilename"

  set targetBalanceCount [expr $nodecount * $targetRunsPerNode]
  puts "targetBalanceCount= $targetBalanceCount"
  set framesPerTask [expr int ($numFrames / $targetBalanceCount) ] 
  #range check here?
  set remainder [expr $numFrames % $targetBalanceCount ]
  if {$remainder ==0} {
    set balanceCount $targetBalanceCount
  } else { 
    set balanceCount [expr $targetBalanceCount + int(ceil((1.0*$remainder) / $framesPerTask))]
    puts "Node $nodecount, have remainder, set balanceCount= $balanceCount"
  }

# XX range check for giant node count?

#  if {$balanceCount > $numFrames} {
#    set balanceCount $numFrames
#  }
 
  set userdata [list $numFrames $dataValNum $trajectoryFilename $setStructFilename $ccMapRes $ccMapSpacing $ccUseMapSpacing $ccThreshold $ccUseThreshold $balanceCount $targetBalanceCount $framesPerTask $remainder] 
  puts "set userdata, userdata= $userdata"
  showTime "Now for parallel for, numFrames = $numFrames, dataValNum= $dataValNum trajectoryFilename= $trajectoryFilename, setStructFilename= $setStructFilename, ccMapRes= $ccMapRes, ccMapSpacing=  $ccMapSpacing, ccUseMapSpacing= $ccUseMapSpacing, ccThreshold= $ccThreshold, ccUseThreshold= $ccUseThreshold, targetBalanceCount= $targetBalanceCount, balanceCount= $balanceCount, framesPerTask $framesPerTask, remainder= $remainder, nodecount= $nodecount"

  parallel for 0 [expr $balanceCount - 1] mpiCrossCorrFrame $userdata 

  showTime "After parallel for Node $noderank"

  parallel barrier
  showTime "After parallel barrier, Node $noderank"
  
  set gatherList [parallel allgather $::localList]
  showTime "After parallel allgather, Node $noderank "
  if {$noderank == 0 } {
    ##puts "Node $noderank gatherList= $gatherList"
  }
  # only print messages on node 0
  set thePid [pid]
  #set outFileName "crosscorr"
  set labelText "cross corr."
  if {$noderank == 0} {
   showTime "before writeCombineGathered call: outFilename= $outFilename labelText= $labelText"
    writeCombineGathered $outFilename $labelText $dataValNum $numFrames $gatherList
  }

}







