########################################################
# This script sets up a Tk panel for switching on and  #
# off the non-animated (static) elastic rod complexes  #
# Frames for dials and buttons are pre-set and will be #
# filled later on, when the molecular sets are loaded  #
########################################################

#------ An auxillliary function ------------#
proc dial_label { top_frame n_label txt } {
    global menu_col

    return [label $top_frame.$n_label \
		    -text $txt \
		    -bd 0 \
		    -activebackground $menu_col(bg,frame) \
		    -bg $menu_col(bg,frame) \
		    -activeforeground $menu_col(fg) \
		    -fg $menu_col(fg) \
		    -highlightthickness 0]
}

#----------- The panel -------------------#
#set switcher [toplevel .static_rod_panel -bg $menu_col(bg,frame)]
#wm title $switcher "385 bp Loops"

set switcher [main_menu_frame_level_2 $control 4]

#----------- The dials -------------------#
set static_dials [main_menu_sub_frame $switcher 0]
pack $static_dials -side right -fill both -expand 1 -anchor s

set dials_frame(0) [main_menu_sub_frame $static_dials 0]

set static_label(dna)    [dial_label $dials_frame(0) 0 "DNA "]
set static_label(rod)    [dial_label $dials_frame(0) 1 "Rod "]
set static_label(efield) [dial_label $dials_frame(0) 2 " E  "]
set static_label(force)  [dial_label $dials_frame(0) 3 " F  "]

foreach m {dna rod efield force} {
    pack $static_label($m) \
	  -side left -fill both -expand 1 -padx 2 -pady 2
}
pack $dials_frame(0) -side top -fill both -expand 1

#-------- A space --------#

set spacer [main_menu_sub_frame $switcher 2]
$spacer configure -width 10
pack $spacer -side right -fill both -expand 0 -anchor s

#-------- The buttons -------#
set static_buttons [main_menu_sub_frame $switcher 1]
pack $static_buttons -side left -fill both -expand 1 -anchor s

set static_label(0)  [dial_label $static_buttons 0 " "]
$static_label(0) configure -bd 2
pack $static_label(0) \
    -side top -fill both -expand 1 -padx 2 -pady 2

########################################################
