##################################################
# This script loads a set of static elastic loop #
# structures with a reduced set of accesories,   #
# including:                                     #
#   - the coarse-grained rod,                    #
#   - the all-atom structure built on top of it, #
#   - the electric field force lines,            #
#   - the forces of protein-DNA interaction,     #
#  and sets up a Tk frame within the window      #
#  $parent_menu that manages that set.           #
##################################################

proc load_static_set { i_set dir dials_frame buttons_frame title } {
    global mol_set menu_col
    global site_flag selections styles colors

    cd $dir

#########################################
# Load and set up the all-atom DNA loop #
#########################################

mol load psf dna.psf pdb dna.pdb

set mol_set($i_set,dna) [molinfo top]

mol delrep 0 top

foreach i {1 2} {
    mol selection  $selections(dna,main,$i)
    mol representation $styles(dna,main,$i)
    mol color          $colors(dna,main,$i)
    mol addrep top
}

set mol_set($i_set,dna,lac,numrep) [molinfo top get numreps]
mol selection  $selections(dna,lac)
mol representation $styles(dna,lac,1)
mol color          $colors(dna,lac)
mol addrep top
set site_flag(lac) 1

######################################
# Load and set up the elastic rod    #
# the electric field lines of force, #
# the forces of the lac repressor/   # 
# DNA interaction                    #
######################################

foreach m {rod efield force} {

    mol load psf $m.psf pdb $m.pdb

    set mol_set($i_set,$m) [molinfo top]

    mol delrep 0 top

    mol representation $styles($m)
    mol color $colors($m)
    mol selection $selections($m)
    mol addrep top
}

#####################################
# Turn off the molecules and set up #
# the correspondent flag variables  #
#####################################

foreach m {dna rod efield force} {
    molinfo $mol_set($i_set,$m) set drawn 0
    molinfo $mol_set($i_set,$m) set active 1
    set mol_set($i_set,$m,flag) 0
}

set mol_set($i_set,flag) 0

#######################################
# Set up the Tk button to turn on/off #
# the static elastic rod set          #
#######################################

set mol_set($i_set,menu,all) \
    [static_set_menu_main_button $i_set $title $buttons_frame]
pack $mol_set($i_set,menu,all) \
    -side top -fill both -expand 1 -padx 2 -pady 1

#############################################
# Set up the Tk dials to turn on/off the    #
# various components of the elastic rod set #
#############################################

set mol_set($i_set,menu) [mol_set_menu_sub_frame \
					$dials_frame dials_$i_set ]

set mol_set($i_set,menu,dna) \
    [mol_set_dial $i_set dna "dna_switch $i_set"]
pack $mol_set($i_set,menu,dna) \
    -side left -fill both -expand 1 -anchor center -padx 2 -pady 1

foreach m {rod efield force} {
    set mol_set($i_set,menu,$m) \
	  [mol_set_dial $i_set $m "mol_switch $i_set $m"]
    pack $mol_set($i_set,menu,$m) \
	  -side left -fill both -expand 1 -anchor center -padx 2 -pady 1
}

pack $mol_set($i_set,menu) -side top -fill both -expand 1

#####################

cd ..
display update on

#####################

}

############################
#- Auxilliary subroutines -#
############################

proc mol_set_menu_sub_frame { parent_menu n_frame } {
    global menu_col

    return [frame $parent_menu.$n_frame \
		   -bg $menu_col(bg,frame) \
		   -bd 0 \
		   -highlightthickness 0 ]
}

proc mol_set_dial { i_set molname cmd } {
    global mol_set menu_col

    return [checkbutton $mol_set($i_set,menu).$molname \
		    -variable mol_set($i_set,$molname,flag) \
		    -command $cmd \
		    -bd 2 \
		    -anchor center \
		    -indicatoron true \
		    -activebackground $menu_col(bg,frame) \
		    -bg $menu_col(bg,frame) \
		    -activeforeground $menu_col(fg) \
		    -fg $menu_col(fg) \
		    -selectcolor $menu_col(bg,act,1) \
		    -highlightthickness 0 ]
}

proc static_set_menu_main_button { i_set txt up_frame } {
    global mol_set menu_col

    return [checkbutton $up_frame.$i_set \
		    -text $txt \
		    -variable mol_set($i_set,flag) \
		    -command "mol_set_on_off $i_set" \
		    -bd 2 \
		    -anchor center \
		    -indicatoron false \
		    -activebackground $menu_col(bg,act,$mol_set($i_set,flag)) \
		    -bg $menu_col(bg,button) \
		    -activeforeground $menu_col(fg) \
		    -fg $menu_col(fg) \
		    -selectcolor $menu_col(bg,act,1) \
		    -highlightthickness 0 ]
}

############################
