########################################################
# This script loads a set of animated elastic loop     #
# structures with a full set of accesoires, including: #
#   - the coarse-grained rod,                          #
#   - the all-atom structure built on top of it,       #
#   - the CAP protein fitted to its binding site,      #
#   - the electric field force lines,                  #
#   - the forces of protein-DNA interaction,           #
# and sets up a Tk window that manages that set.       #
########################################################

proc load_set { i_set dir title main_menu_frame } {
    global mol_set menu_col
    global site_flag selections styles colors

    cd $dir

#########################################
# Load and set up the all-atom DNA loop #
#########################################

mol load psf dna.psf pdb dna_0.pdb

set mol_set($i_set,dna) [molinfo top]

load_num_pbds $mol_set($i_set,dna) "dna"

#-- Set up the representations --#

mol delrep 0 top

foreach i {1 2} {
    mol selection  $selections(dna,main,$i)
    mol representation $styles(dna,main,$i)
    mol color          $colors(dna,main,$i)
    mol addrep top
}

foreach site {gene cap rnap lac} {
    set mol_set($i_set,dna,$site,numrep) [molinfo top get numreps]
    mol selection  $selections(dna,$site)
    mol representation $styles(dna,$site,1)
    mol color          $colors(dna,$site)
    mol addrep top
    set site_flag($site) 1
}

#####################################################
# Load and set up the elastic rod, the CAP protein, #
# the electric field lines of force, and the forces #
# of the lac repressor/DNA interaction              #
#####################################################

foreach m {rod cap efield force} {

    mol load psf $m.psf pdb $m\_0.pdb

    set mol_set($i_set,$m) [molinfo top]

    load_num_pbds $mol_set($i_set,$m) $m

    #-- Set up the representations --#

    mol delrep 0 top

    mol representation $styles($m)
    mol color $colors($m)
    mol selection $selections($m)
    mol addrep top
}

#####################################
# Turn off the molecules and set up #
# the correspondent flag variables  #
#####################################

foreach m {dna rod cap efield force} {
    molinfo $mol_set($i_set,$m) set drawn 0
    molinfo $mol_set($i_set,$m) set active 1
    set mol_set($i_set,$m,flag) 0
}

set mol_set($i_set,flag) 0

#####################################
# Read the animation scenario       #
# (if none, set up the default one) #
#  and reset the animation state    #
#####################################

if { [llength [glob "Scenario.tcl"]] } then {
    source Scenario.tcl 
} else { 
    default_scenario $i_set
}

set_state $i_set 0

########################
# Set up the Tk window #
########################

set mol_set($i_set,menu) $main_menu_frame

#-- ---- ---- ---- --#

set mol_set($i_set,menu,all) \
    [mol_set_menu_main_button $i_set $title]
pack $mol_set($i_set,menu,all) \
    -side top -fill both -expand 1 -padx 100 -pady 4

#-- ---- ---- ---- --#

set mol_set($i_set,menu,1) [mol_set_menu_frame $i_set 1]

foreach m {dna rod cap efield force} \
    txt {"DNA" "Rod" "CAP" " E " " F "} {
	  set mol_set($i_set,menu,$m) \
		[mol_set_menu_button $i_set 1 $txt $m]
	  pack $mol_set($i_set,menu,$m) \
		-side left -fill both -expand 1 -padx 2 -pady 2
    }
pack $mol_set($i_set,menu,1) \
    -side top -fill both -expand 1 -padx 0 -pady 0

#-- ---- ---- ---- --#

set mol_set($i_set,menu,3) [mol_set_menu_frame $i_set 3]

set mol_set($i_set,menu,3,0) \
    [mol_set_menu_arrow $i_set 3 0 "@../left.bmp" \
	   "change_state $i_set -1"]

set mol_set($i_set,menu,3,1) \
    [mol_set_menu_arrow $i_set 3 1 "@../left_double.bmp" \
	   "change_state_play $i_set -1"]

set mol_set($i_set,menu,3,2) \
    [mol_set_menu_arrow $i_set 3 2 "@../right_double.bmp" \
	   "change_state_play $i_set 1"]

set mol_set($i_set,menu,3,3) \
    [mol_set_menu_arrow $i_set 3 3 "@../right.bmp" \
	   "change_state $i_set 1"]

foreach i {0 1 2 3} { 
    pack $mol_set($i_set,menu,3,$i) \
	  -side left -fill both -expand 1 -padx 2 -pady 2
}
pack $mol_set($i_set,menu,3) \
    -side top -fill both -expand 1 -padx 0 -pady 0

#####################

cd ..
display update on

#####################

}

############################
#- Auxilliary subroutines -#
############################

proc load_num_pbds { mol_num pref } {
    set patt $pref\_\[0-9\]\*.pdb
    set lastfile [lindex [lsort -dictionary [glob $patt]] end]

    set i_1 [expr [string length $pref\_] - 1]
    set ilast [string replace $lastfile 0 $i_1]
    set ilast [string replace $ilast end-3 end]

    for { set i 1 } { $i <= $ilast } { incr i } { 
	  animate read pdb $pref\_$i.pdb $mol_num
    }
}

proc mol_set_menu_frame { i_set frame_num } {
    global mol_set menu_col

    return [frame $mol_set($i_set,menu).$frame_num \
		    -bg $menu_col(bg,frame) \
		    -bd 0 \
		    -highlightthickness 0]
}

proc mol_set_menu_main_button { i_set txt } {
    global mol_set menu_col

    return [checkbutton $mol_set($i_set,menu).all \
		    -text $txt \
		    -variable mol_set($i_set,flag) \
		    -command "mol_set_on_off $i_set" \
		    -anchor center \
		    -indicatoron false \
		    -activebackground $menu_col(bg,act,$mol_set($i_set,flag)) \
		    -bg $menu_col(bg,button) \
		    -activeforeground $menu_col(fg) \
		    -fg $menu_col(fg) \
		    -selectcolor $menu_col(bg,act,1) \
		    -highlightthickness 0 ]
}

proc mol_set_menu_button { i_set frame_num txt molname} {
    global mol_set menu_col

    return [checkbutton $mol_set($i_set,menu,$frame_num).$molname \
		    -text $txt \
		    -anchor center \
		    -indicatoron false \
		    -variable mol_set($i_set,$molname,flag) \
		    -command "mol_on_off $i_set $molname" \
		    -activebackground $menu_col(bg,act,$mol_set($i_set,$molname,flag)) \
		    -bg $menu_col(bg,button) \
		    -activeforeground $menu_col(fg) \
		    -fg $menu_col(fg) \
		    -selectcolor $menu_col(bg,act,1) \
		    -highlightthickness 0 ]
}

proc mol_set_menu_arrow { i_set frame_num button_num btmap cmd} {
    global mol_set menu_col

    return [button $mol_set($i_set,menu,$frame_num).$button_num \
		    -bitmap $btmap \
		    -command $cmd \
		    -anchor center \
		    -activebackground $menu_col(bg,button) \
		    -bg $menu_col(bg,button) \
		    -activeforeground $menu_col(fg) \
		    -fg $menu_col(fg) \
		    -highlightthickness 0 ]
}

proc default_scenario { i_set } {
    global mol_set

    set l_numf {}

    foreach m {dna rod cap efield force} {
	  set numf($m) [molinfo $mol_set($i_set,$m) get numframes]
	  set numf($m) [expr $numf($m) - 1]
	  lappend l_numf $numf($m) 
    }

    set numf_max [lindex [lsort $l_numf] end]
    set mol_set($i_set,max_anim_state) $numf_max

    foreach m {dna rod cap efield force} {
	  for { set i 0 } {$i<=$numf_max} {incr i} {
		if { $i < $numf($m) } then { 
		    set mol_set($i_set,$m,stop_frame,$i) $i
		} else {
		    set mol_set($i_set,$m,stop_frame,$i) $numf($m)
		}
	  }
    }
}

############################
