#-------------------------------------------------------------#

proc mol_on_off {i_set mol_name} {
    global mol_set menu_col

    set flag $mol_set($i_set,$mol_name,flag)

    $mol_set($i_set,menu,$mol_name) configure \
	  -activebackground $menu_col(bg,act,$flag)

    if { $mol_name == "dna" } then {
	  dna_switch $i_set
    } else {
	  mol_switch $i_set $mol_name
    }
}

proc mol_switch {i_set mol_name} {
    global mol_set menu_col

    display update off

    set m_flag [expr $mol_set($i_set,$mol_name,flag) & \
			  $mol_set($i_set,flag)]
    molinfo $mol_set($i_set,$mol_name) set drawn $m_flag

    display update on
}

proc dna_switch {i_set} {
    global mol_set num_dnas_on

    display update off

    set flag [expr $mol_set($i_set,dna,flag) & \
			$mol_set($i_set,flag)]

    set i_state [molinfo $mol_set($i_set,dna) get drawn]
    if { $flag == $i_state } { return }

    if { $flag == 1 } then {
	  incr num_dnas_on
	  molinfo $mol_set($i_set,dna) set drawn 1
	  lac_dna_on_off 0
    } else {
	  set num_dnas_on [expr $num_dnas_on - 1] 
	  if { $num_dnas_on == 0 } then { lac_dna_on_off 1 }
	  molinfo $mol_set($i_set,dna) set drawn 0
    }
    
    display update on
}

#-------------------------------------------------------------#

proc change_state {i_set step} {
    global mol_set

    display update off

    set max_anim_state $mol_set($i_set,max_anim_state)
    set anim_state [expr $mol_set($i_set,anim_state) + $step]
#- Current behavior: cannot move further back/forward from -#
#- the terminal animation states (0 and $max_anim_state)   -#
    if { $anim_state < 0 } { set anim_state 0 }
    if { $anim_state > $max_anim_state } { set anim_state $max_anim_state }
#- Alternative behavior: cycling over the animation states, -#
#- forward button pushes from last to first, and vice versa -#
#    if { $anim_state < 0 } {
#	  set anim_state [expr $max_anim_state + 1 + $anim_state]
#    }
#    if { $anim_state > $max_anim_state } {
#	  set anim_state [expr $anim_state - $max_anim_state - 1]
#    }
#
    set_state $i_set $anim_state

    display update on
}

proc set_state {i_set i_state} {
    global mol_set

    foreach m {rod dna cap efield force} { 
	  molinfo $mol_set($i_set,$m) set frame $mol_set($i_set,$m,stop_frame,$i_state)
    }

    set mol_set($i_set,anim_state) $i_state
}

#-------------------------------------------------------------#

proc change_state_play {i_set step} {
    global mol_set

    display update off

    set max_anim_state $mol_set($i_set,max_anim_state)
    set anim_state [expr $mol_set($i_set,anim_state) + $step]
#- Current behavior: cannot move further back/forward from -#
#- the terminal animation states (0 and $max_anim_state)   -#
    if { $anim_state == -1 } { set anim_state 0 }
    if { $anim_state > $max_anim_state } { set anim_state $max_anim_state }
#- Alternative behavior: cycling over the animation states, -#
#- forward button pushes from last to first, and vice versa -#
#    if { $anim_state < 0 } {
#	  set anim_state [expr $max_anim_state + 1 + $anim_state]
#    }
#    if { $anim_state > $max_anim_state } {
#	  set anim_state [expr $anim_state - $max_anim_state - 1]
#    }
#
    set num_to_go 5
    foreach m {rod dna cap efield force} { set done($m) 0 }

    while {$num_to_go>0} {
	  foreach m {rod dna cap efield force} {
		if { done($m) } then { continue }
		set fr [molinfo $mol_set($i_set,$m) get frame]
		if { $fr != $mol_set($i_set,$m,$stop_frame,$anim_state) } then {
		    molinfo $mol_set($i_set,$m) set frame [expr $fr + $step]
		} else { 
		    set done($m) 1
		    set num_to_go [expr $num_to_go - 1]
		}
	  }
	  display update
    }

    set mol_set($i_set,anim_state) $anim_state

    display update on
}

#-------------------------------------------------------------#

