#!/usr/local/bin/vmd

#####################

display update off

##########################
# Set up the menu colors #
##########################

set menu_col(bg,frame)  \#ba0
set menu_col(bg,button) \#cb0
set menu_col(bg,act,0)  $menu_col(bg,button)
set menu_col(bg,act,1)  \#0f0
set menu_col(fg)        \#040

####################################
# Set up the representation styles #
####################################

### For the all-atom DNA loop: ###

set selections(dna,main,1) {not (hydrogen or name "O.P")}
set colors(dna,main,1) "ColorID 4"
set styles(dna,main,1) "Bonds 0.3 6"

set selections(dna,main,2) {all}
set colors(dna,main,2) "ColorID 1"
set styles(dna,main,2) "Tube 0.6 7"

#-----  The Lac repressor binding site --#
set selections(dna,lac) {resid "-89" to "-74" 3 to 18}
set colors(dna,lac) "ColorID 10"
set styles(dna,lac,1) "Tube 1.4 8"
set styles(dna,lac,0) "Off"

#-----  The CAP binding site --#
set selections(dna,cap) {resid "-70" to "-53" and not (hydrogen or backbone or name O4' C2')}
set colors(dna,cap) "ColorID 7"
set styles(dna,cap,1) "VDW 1.5 8"
set styles(dna,cap,0) "Off"

#-----  The RNA polymerase binding site --#
set selections(dna,rnap) {resid "-39" to "-1" and not (hydrogen or backbone or name O4' C2')}
set colors(dna,rnap) "ColorID 11"
set styles(dna,rnap,1) "VDW 1.5 8"
set styles(dna,rnap,0) "Off"

set selections(dna,gene) {resid >= 1 and not (hydrogen or backbone or name O4' C2')}
set colors(dna,gene) "ColorID 4"
set styles(dna,gene,1) "VDW 1.7 8"
set styles(dna,gene,0) "Off"

### For the Lac repressor: ###

#-----  The protein --#
set selections(lac,pro) {segname "CA_."}
set colors(lac,pro) "SegName"
set styles(lac,pro) {Cartoon 2.8 15 6}

#-----  The attached DNA segments --#
set selections(lac,dna,0)  {segname ".DNA"}
set colors(lac,dna,0) $colors(dna,lac)
set styles(lac,dna,0,1) $styles(dna,lac,1)
set styles(lac,dna,0,0) "Off"

foreach i {1 2} {
    set selections(lac,dna,$i)  {segname ".DNA"}
    set colors(lac,dna,$i) $colors(dna,main,$i)
    set styles(lac,dna,$i,1) $styles(dna,main,$i)
    set styles(lac,dna,$i,0) "Off"
}

### For the CAP protein: ###

set selections(cap) {all} 
set colors(cap) "ColorID 7"
set styles(cap) "Cartoon 2.8 15 6"

# For the elastic rods: #

set selections(rod) {all}
set colors(rod) "ColorID 2"
set styles(rod) "Ribbons 2.0 11 20"

### For the electric field: ###

set selections(efield) {all}
set colors(efield) "ColorID 4"
set styles(efield) "Lines 1"

### For the protein/DNA interaction force: ###

set selections(force) {all}
set colors(force) "ColorID 7"
set styles(force) "Licorice 1 8 8"


#######################################
# Load and set up the X-ray structure #
# of the Lac repressor/DNA complex    #
#######################################

mol load psf lac_w_dna.psf pdb 1efa_dimer.pdb

set lac [molinfo top]

molinfo top set drawn 0
molinfo top set active 1

mol delrep 0 top

mol representation $styles(lac,pro)
mol color          $colors(lac,pro)
mol selection  $selections(lac,pro)
mol addrep top

set lac_dna_numrep [molinfo top get numreps]

foreach i {0 1 2} {
    mol representation $styles(lac,dna,$i,1)
    mol color $colors(lac,dna,$i)
    mol selection $selections(lac,dna,$i)
    mol addrep top
}

set lac_flag 0
set num_dnas_on 0

###########################################
# Load and set up the ions and water bath #
###########################################

mol load pdb ions.pdb

set ions [molinfo top]

molinfo top set drawn 0
molinfo top set active 1

mol delrep 0 top
mol representation VDW 1.0 8
mol color Name
mol selection {all}
mol addrep top

mol load psf water_bath.psf pdb water_bath.pdb

set water [molinfo top]

molinfo top set drawn 0
molinfo top set active 1

mol delrep 0 top
# mol representation Dotted 1.0 1
mol representation Lines
mol color ColorID 10
mol selection {name OH2}
mol addrep top

set wat_flag 0

############################################
# Read up a set of TcL procedures designed #
# to load and set up the presentation of   #
# the solutions to the elastic rod problem #
############################################

source set_procedures.tcl
source load_set.tcl

####################################
# Set up the main Tk control panel #
####################################

source main_panel.tcl

##############################################
# Set up the animation scenario for Loop 1:  #
# the first set of animated solution of the  #
# elastic rod problem for the short DNA loop #
##############################################

set mol_set(1,max_anim_state) 2

set mol_set(1,dna,stop_frame,0) 0
set mol_set(1,dna,stop_frame,1) 1
set mol_set(1,dna,stop_frame,2) 2

set mol_set(1,rod,stop_frame,0) 0
set mol_set(1,rod,stop_frame,1) 0
set mol_set(1,rod,stop_frame,2) 1

for {set i 0} {$i<=$mol_set(1,max_anim_state)} {incr i} {
    set mol_set(1,cap,stop_frame,$i)    0 
    set mol_set(1,efield,stop_frame,$i) 0 
    set mol_set(1,force,stop_frame,$i)  0 
}

##########################
# Load and set up Loop 1 #
##########################

load_set 1 "Short_1" "76 bp Loop 1"

set rod_button(1) [menu_check_button $frame_2 1 \
			     "76 bp Loop 1" mol_set(1,flag)]
$rod_button(1) configure -command "mol_set_on_off 1 $rod_button(1)"
pack $rod_button(1) -side left -fill both -expand 1

set mol_set(1,flag) 1
mol_set_on_off 1 $rod_button(1)
set mol_set(1,dna,flag) 1
mol_on_off 1 dna

##############################################
# Set up the animation scenario for Loop 0:  #
# the second set of animated solution of the #
# elastic rod problem for the short DNA loop #
##############################################

set mol_set(0,max_anim_state) 2

set mol_set(0,dna,stop_frame,0) 0
set mol_set(0,dna,stop_frame,1) 1
set mol_set(0,dna,stop_frame,2) 2

set mol_set(0,rod,stop_frame,0) 0
set mol_set(0,rod,stop_frame,1) 0
set mol_set(0,rod,stop_frame,2) 1

for {set i 0} {$i<=$mol_set(0,max_anim_state)} {incr i} {
    set mol_set(0,cap,stop_frame,$i)    0 
    set mol_set(0,efield,stop_frame,$i) 0 
    set mol_set(0,force,stop_frame,$i)  0 
}

##########################
# Load and set up Loop 0 #
##########################

load_set 0 "Short_0" "76 bp Loop 0"

set rod_button(0) [menu_check_button $frame_2 0 \
			     "76 bp Loop 0" mol_set(0,flag)]
$rod_button(0) configure -command "mol_set_on_off 0 $rod_button(0)"
pack $rod_button(0) -side left -fill both -expand 1

set mol_set(0,rod,flag) 1
mol_on_off 0 rod

#############################################
# Load and set up four static solutions to  #
# the elastic rod problem for the long loop #
#############################################

source load_reduced_set.tcl

source static_rod_panel.tcl

load_reduced_set 2 "Long_Up+1"   $static_dials 1
load_reduced_set 3 "Long_Up_0"   $static_dials 2
load_reduced_set 4 "Long_Down-1" $static_dials 3
load_reduced_set 5 "Long_Down_0" $static_dials 4

foreach i {1 2 3 4} txt {" Up   1 "  " Up   0 " " Down 1 " " Down 0 "} {
    set i_set [expr $i+1]
    set static_button($i) [menu_check_button $static_buttons $i \
					 $txt mol_set($i_set,flag) ]
    $static_button($i) configure -command \
	  "mol_set_on_off $i_set $static_button($i)"
    pack $static_button($i) -side top -fill both -expand 1
}

foreach i_set {2 3 4 5} {
    set mol_set($i_set,rod,flag) 1
    mol_switch $i_set rod
}

#########################################################
# Set up the initial viewing matrices for all molecules #
#########################################################

set ini_cent_mtrx {{
    {1. 0. 0. -101.875534} 
    {0. 1. 0.   -5.245209}
    {0. 0. 1.  -79.260536}
    {0. 0. 0.    1.      } }}

set ini_rot_mtrx {{
    { 0.479697 -0.235831 -0.845146 0.}
    { 0.877199  0.106622  0.468138 0.}
    {-0.020291 -0.965925  0.258017 0.}
    { 0.        0.        0.       1.} }}

set ini_scale_mtrx {{
    {0.011904 0. 0. 0.}
    {0. 0.011904 0. 0.}
    {0. 0. 0.011904 0.}
    {0. 0.    0.    1.} }}

set ini_glob_mtrx {{
    {1. 0. 0. -1.  }
    {0. 1. 0.  0.34}
    {0. 0. 1. -0.15}
    {0. 0. 0.  1.  } }}

foreach m [concat $lac $water $ions] {
    molinfo $m set center_matrix $ini_cent_mtrx 
    molinfo $m set rotate_matrix $ini_rot_mtrx 
    molinfo $m set scale_matrix $ini_scale_mtrx 
    molinfo $m set global_matrix $ini_glob_mtrx 
}

foreach i_set {0 1} {
    foreach m {dna rod cap efield force} {
	  molinfo $mol_set($i_set,$m) set center_matrix $ini_cent_mtrx 
	  molinfo $mol_set($i_set,$m) set rotate_matrix $ini_rot_mtrx 
	  molinfo $mol_set($i_set,$m) set scale_matrix $ini_scale_mtrx 
	  molinfo $mol_set($i_set,$m) set global_matrix $ini_glob_mtrx 
    }
}

foreach i_set {2 3 4 5} {
    foreach m {dna rod efield force} {
	  molinfo $mol_set($i_set,$m) set center_matrix $ini_cent_mtrx 
	  molinfo $mol_set($i_set,$m) set rotate_matrix $ini_rot_mtrx 
	  molinfo $mol_set($i_set,$m) set scale_matrix $ini_scale_mtrx 
	  molinfo $mol_set($i_set,$m) set global_matrix $ini_glob_mtrx 
    }
}

##############################
# Set up the coloring scheme #
##############################

color Resname {ADE} red
color Resname {CYT} gray
color Resname {GUA} blue
color Resname {THY} orange
color Resname {URA} tan
color Chain {A} blue
color Chain {B} red
color Chain {D} tan
color Chain {C} silver
color Segname {ADNA} red
color Segname {BDNA} blue
color Segname {DUMM} green
color Segname {CA_1} purple
color Segname {CA_2} gray
color Segname {CA_3} purple
color Segname {CA_4} gray

#####################

display update on
## display stereo CrystalEyes

menu graphics off
menu molecule off

#####################

