#===============#
#  Procedures   #
#===============#

#-- The 'representation on/off' procedures --#

#--       Reps of the DNA molecule ----------#

proc lac_site_on_off {} {
    global site_flag num_dnas_on mol_set
    global lac lac_dna_numrep
		   
    site_on_off lac

    if { $num_dnas_on == 0 } then {
	  mol modstyle $lac_dna_numrep $lac $styles(dna,lac,$site_flag(lac))
    }
}

proc site_on_off {site} {
    global site_flag styles mol_set

    foreach m_rep [array names mol_set \[0-9+\],dna,$site,numrep] {
	  set i_cut [string last ",$site,numrep" $m_rep]
	  set m_num [string replace $m_rep $i_cut end]
	  mol modstyle $mol_set($m_rep) $mol_set($m_num) \
		$styles(dna,$site,$site_flag($site))
    }
}

#--       Reps of the lac repressor molecule ----------#

proc lac_dna_on_off {i_switch} {
    global site_flag styles
    global lac lac_dna_numrep

    set flag_1 [expr $site_flag(lac) & $i_switch]
    mol modstyle $lac_dna_numrep $lac $styles(dna,lac,$flag_1)
    mol modstyle [expr $lac_dna_numrep+1] $lac $styles(lac,dna,1,$i_switch)
    mol modstyle [expr $lac_dna_numrep+2] $lac $styles(lac,dna,2,$i_switch)
}

#-- The 'molecule on/off' procedures --#

proc lac_on_off {lac_button} {
    global lac lac_flag num_dnas_on menu_col

    display update off
    
    $lac_button configure -activebackground $menu_col(bg,act,$lac_flag)

    if { $lac_flag == 0 } then {
	  molinfo $lac set drawn 0
    } else {
	  if { $num_dnas_on == 0 } { lac_dna_on_off 1 }
	  molinfo $lac set drawn 1
    }

    display update on
}

proc wat_on_off {wat_button} {
    global water ions wat_flag menu_col

    display update off
    
    $wat_button configure -activebackground $menu_col(bg,act,$wat_flag)

    molinfo $water set drawn $wat_flag
    molinfo $ions set drawn $wat_flag

    display update on
}

proc mol_set_on_off {i_set set_button} {
    global mol_set menu_col

    display update off

    $set_button configure -activebackground $menu_col(bg,act,$mol_set($i_set,flag))

    dna_switch $i_set
    display update off

    foreach m {rod efield force} { 
	  set m_flag [expr $mol_set($i_set,flag) & $mol_set($i_set,$m,flag)]
	  molinfo $mol_set($i_set,$m) set drawn $m_flag
    }

    if { [info exists mol_set($i_set,cap)] } {
	  set m_flag [expr $mol_set($i_set,flag) & $mol_set($i_set,cap,flag)]
	  molinfo $mol_set($i_set,cap) set drawn $m_flag
    }

    display update on
}

####################################################
# Auxilliary functions, creating Tk frames/buttons #
####################################################

proc main_menu_frame { main_menu frame_num } {
    global menu_col

    return [frame $main_menu.$frame_num \
		    -bg $menu_col(bg,frame) \
		    -bd 2 \
		    -relief ridge \
		    -highlightthickness 0]
}

proc main_menu_sub_frame { up-frame frame_num } {
    global menu_col

    return [frame $up-frame.$frame_num \
		    -bg $menu_col(bg,frame) \
		    -bd 2 \
		    -relief flat \
		    -highlightthickness 0]
}

proc toggler_check_button {toggler n_button txt site cmd} {
    global site_flag menu_col

    return [checkbutton $toggler.$n_button \
		    -text $txt \
		    -variable site_flag($site) \
		    -command $cmd \
		    -anchor center \
		    -indicatoron true \
		    -activebackground $menu_col(bg,frame) \
		    -bg $menu_col(bg,frame) \
		    -activeforeground $menu_col(fg) \
		    -fg $menu_col(fg) \
		    -selectcolor $menu_col(bg,act,1) \
		    -highlightthickness 0 ]
}

proc menu_check_button { main_menu_frame n_button txt var_name } {
    global menu_col
#    upvar flag $var_name

    return [checkbutton $main_menu_frame.$n_button \
		    -text $txt \
		    -variable $var_name \
		    -anchor center \
		    -indicatoron false \
		    -activebackground $menu_col(bg,button) \
		    -bg $menu_col(bg,button) \
		    -activeforeground $menu_col(fg) \
		    -fg $menu_col(fg) \
		    -selectcolor $menu_col(bg,act,1) \
		    -highlightthickness 0 ]
}

##########################################
# Set up the main Tk window for the Lac  #
# operon repression complex presentation #
##########################################

#-- Create the main control panel --#

set control [toplevel .control_panel \
		     -bg $menu_col(bg,frame) \
		     -highlightthickness 4 \
		     -highlightbackground $menu_col(bg,frame) \
		     -highlightcolor $menu_col(bg,frame) ]
wm title $control "Repression Complex"

#-- Create the toggler of various sites of the Lac promoter --#

set toggler [main_menu_frame $control 0]

set tgl_but(1) [toggler_check_button $toggler 1 "Gene " gene \
			  "site_on_off gene"]

set tgl_but(2) [toggler_check_button $toggler 2 "RNAP " rnap \
			  "site_on_off rnap"]

set tgl_but(3) [toggler_check_button $toggler 3 "CAP " cap \
			  "site_on_off cap"]

set tgl_but(4) [toggler_check_button $toggler 4 "LacR " lac \
			  "lac_site_on_off"]

foreach i {1 2 3 4} {
    pack $tgl_but($i) -side left -fill both -expand 1 -padx 1 -pady 1
}
pack $toggler -side top -fill both -expand 1 -padx 1 -pady 1

#-- Create buttons for turning molecules on and off --#

#--     The Lac repressor and the water bath ---#
set up-frame_1 [main_menu_frame $control 1]
pack $up-frame_1 -side top -fill both -expand 1 -padx 1 -pady 1

set frame_1 [main_menu_sub_frame $up-frame_1 0]
pack $frame_1 -side top -fill both -expand 1 -padx 4 -pady 4

set lac_button [menu_check_button $frame_1 0 "Lac Repressor" lac_flag]
$lac_button configure -command "lac_on_off $lac_button"

set wat_button [menu_check_button $frame_1 1 "Water/Na Bath" wat_flag]
$wat_button configure -command "wat_on_off $wat_button"

pack $lac_button -side left -fill both -expand 1 -padx 1 -pady 1
pack $wat_button -side left -fill both -expand 1 -padx 1 -pady 1

#---   The short (animated) elastic rod complexes   ---#
#-- (here we only pre-set the frame and fill it with --#
#--  buttons later, after the complexes are loaded)  --#
#set frame_2 [main_menu_frame $control 2]
#pack $frame_2 -side top -fill both -expand 1 -padx 1 -pady 1

##########################################
