########################################################
# This script loads a set of animated elastic loop     #
# structures with a full set of accesoires, including: #
#   - the coarse-grained rod,                          #
#   - the all-atom structure built on top of it,       #
#   - the CAP protein fitted to its binding site,      #
#   - the electric field force lines,                  #
#   - the forces of protein-DNA interaction,           #
# and sets up a Tk window that manages that set.       #
########################################################

proc load_set { i_set dir title } {
    global mol_set menu_col
    global site_flag selections styles colors

    cd $dir

#########################################
# Load and set up the all-atom DNA loop #
#########################################

mol load psf dna.psf pdb dna_0.pdb

set mol_set($i_set,dna) [molinfo top]

load_num_pbds $mol_set($i_set,dna) "dna"

#-- Set up the representations --#

mol delrep 0 top

foreach i {1 2} {
    mol selection  $selections(dna,main,$i)
    mol representation $styles(dna,main,$i)
    mol color          $colors(dna,main,$i)
    mol addrep top
}

foreach site {gene cap rnap lac} {
    set mol_set($i_set,dna,$site,numrep) [molinfo top get numreps]
    mol selection  $selections(dna,$site)
    mol representation $styles(dna,$site,1)
    mol color          $colors(dna,$site)
    mol addrep top
    set site_flag($site) 1
}

#####################################################
# Load and set up the elastic rod, the CAP protein, #
# the electric field lines of force, and the forces #
# of the lac repressor/DNA interaction              #
#####################################################

foreach m {rod cap efield force} {

    mol load psf $m.psf pdb $m\_0.pdb

    set mol_set($i_set,$m) [molinfo top]

    load_num_pbds $mol_set($i_set,$m) $m

    #-- Set up the representations --#

    mol delrep 0 top

    mol representation $styles($m)
    mol color $colors($m)
    mol selection $selections($m)
    mol addrep top
}

#####################################
# Turn off the molecules and set up #
# the correspondent flag variables  #
#####################################

foreach m {dna rod cap efield force} {
    molinfo $mol_set($i_set,$m) set drawn 0
    molinfo $mol_set($i_set,$m) set active 1
    set mol_set($i_set,$m,flag) 0
}

set mol_set($i_set,flag) 0

#############################
# Reset the animation state #
#############################

set_state $i_set 0

########################
# Set up the Tk window #
########################

set mol_set($i_set,menu) [toplevel .mol_set_menu_$i_set \
					-bg $menu_col(bg,frame)]
wm title $mol_set($i_set,menu) $title

#-- ---- ---- ---- --#

set mol_set($i_set,menu,1) [mol_set_menu_frame $i_set 1]

foreach m {dna rod cap efield force} \
    txt {"DNA" "Rod" "CAP" " E " " F "} {
	  set mol_set($i_set,menu,$m) \
		[mol_set_menu_button $i_set 1 $txt $m]
	  pack $mol_set($i_set,menu,$m) \
		-side left -fill both -expand 1 -padx 1 -pady 1
    }
pack $mol_set($i_set,menu,1) \
    -side top -fill both -expand 1 -padx 1 -pady 1


#-- ---- ---- ---- --#

set mol_set($i_set,menu,3) [mol_set_menu_frame $i_set 3]

set mol_set($i_set,menu,3,0) \
    [mol_set_menu_arrow $i_set 3 0 "@../left.bmp" \
	   "change_state $i_set -1"]

set mol_set($i_set,menu,3,1) \
    [mol_set_menu_arrow $i_set 3 1 "@../left_double.bmp" \
	   "change_state $i_set -1"]

set mol_set($i_set,menu,3,2) \
    [mol_set_menu_arrow $i_set 3 2 "@../right_double.bmp" \
	   "change_state $i_set 1"]

set mol_set($i_set,menu,3,3) \
    [mol_set_menu_arrow $i_set 3 3 "@../right.bmp" \
	   "change_state $i_set 1"]

foreach i {0 1 2 3} { 
    pack $mol_set($i_set,menu,3,$i) \
	  -side left -fill both -expand 1 -padx 1 -pady 1
}
pack $mol_set($i_set,menu,3) \
    -side top -fill both -expand 1 -padx 1 -pady 1

#####################

cd ..
display update on

#####################

}

############################
#- Auxilliary subroutines -#
############################

proc load_num_pbds { mol_num pref } {
    set patt $pref\_\[0-9\]\*.pdb
    set lastfile [lindex [glob $patt] end]

    set i_1 [expr [string length $pref\_] - 1]
    set ilast [string replace $lastfile 0 $i_1]
    set ilast [string replace $ilast end-3 end]

    for { set i 1 } { $i <= $ilast } { incr i } { 
	  animate read pdb $pref\_$i.pdb $mol_num
    }
}

proc mol_set_menu_frame { i_set frame_num } {
    global mol_set menu_col

    return [frame $mol_set($i_set,menu).$frame_num \
		   -bg $menu_col(bg,frame) \
		   -bd 0 \
		   -highlightthickness 1 \
		   -highlightcolor $menu_col(bg,frame) \
		   -highlightbackground $menu_col(bg,frame) ]
}

proc mol_set_menu_button { i_set frame_num txt molname} {
    global mol_set menu_col

    return [checkbutton $mol_set($i_set,menu,$frame_num).$molname \
		    -text $txt \
		    -anchor center \
		    -indicatoron false \
		    -variable mol_set($i_set,$molname,flag) \
		    -command "mol_on_off $i_set $molname" \
		    -activebackground $menu_col(bg,act,$mol_set($i_set,$molname,flag)) \
		    -bg $menu_col(bg,button) \
		    -activeforeground $menu_col(fg) \
		    -fg $menu_col(fg) \
		    -selectcolor $menu_col(bg,act,1) \
		    -highlightbackground $menu_col(bg,frame) \
		    -highlightthickness 1 ]
}

proc mol_set_menu_arrow { i_set frame_num button_num btmap cmd} {
    global mol_set menu_col

    return [button $mol_set($i_set,menu,$frame_num).$button_num \
		    -bitmap $btmap \
		    -command $cmd \
		    -anchor center \
		    -highlightthickness 1 \
		    -activebackground $menu_col(bg,button) \
		    -bg $menu_col(bg,button) \
		    -activeforeground $menu_col(fg) -fg $menu_col(fg) ]
}

############################
