##################################################
# This script loads a set of static elastic loop #
# structures with a reduced set of accesoires,   #
# including:                                     #
#   - the coarse-grained rod,                    #
#   - the all-atom structure built on top of it, #
#   - the electric field force lines,            #
#   - the forces of protein-DNA interaction,     #
#  and sets up a Tk frame within the window      #
#  $parent_menu that manages that set.           #
##################################################

proc load_reduced_set { i_set dir parent_menu n_frame } {
    global mol_set menu_col
    global site_flag selections styles colors

    cd $dir

#########################################
# Load and set up the all-atom DNA loop #
#########################################

mol load psf dna.psf pdb dna.pdb

set mol_set($i_set,dna) [molinfo top]

mol delrep 0 top

foreach i {1 2} {
    mol selection  $selections(dna,main,$i)
    mol representation $styles(dna,main,$i)
    mol color          $colors(dna,main,$i)
    mol addrep top
}

set mol_set($i_set,dna,lac,numrep) [molinfo top get numreps]
mol selection  $selections(dna,lac)
mol representation $styles(dna,lac,1)
mol color          $colors(dna,lac)
mol addrep top
set site_flag(lac) 1

######################################
# Load and set up the elastic rod    #
# the electric field lines of force, #
# the forces of the lac repressor/   # 
# DNA interaction                    #
######################################

foreach m {rod efield force} {

    mol load psf $m.psf pdb $m.pdb

    set mol_set($i_set,$m) [molinfo top]

    mol delrep 0 top

    mol representation $styles($m)
    mol color $colors($m)
    mol selection $selections($m)
    mol addrep top
}

#####################################
# Turn off the molecules and set up #
# the correspondent flag variables  #
#####################################

foreach m {dna rod efield force} {
    molinfo $mol_set($i_set,$m) set drawn 0
    molinfo $mol_set($i_set,$m) set active 1
    set mol_set($i_set,$m,flag) 0
}

set mol_set($i_set,flag) 0

#############################################
# Set up the Tk dials to turn on/off the    #
# various components of the elastic rod set #
#############################################

set mol_set($i_set,menu) [mol_set_menu_sub_frame \
					$parent_menu dials_$i_set ]

set mol_set($i_set,menu,dna) \
    [mol_set_dial $i_set dna "dna_switch $i_set"]
pack $mol_set($i_set,menu,dna) -side left -fill both -expand 1 -anchor n

foreach m {rod efield force} {
    set mol_set($i_set,menu,$m) \
	  [mol_set_dial $i_set $m "mol_switch $i_set $m"]
    pack $mol_set($i_set,menu,$m) -side left -fill both -expand 1 -anchor center
}

pack $mol_set($i_set,menu) -side top -fill both -expand 1

#####################

cd ..
display update on

#####################

}

############################
#- Auxilliary subroutines -#
############################

proc mol_set_menu_sub_frame { parent_menu n_frame } {
    global menu_col

    return [frame $parent_menu.$n_frame \
		   -bg $menu_col(bg,frame) \
		   -bd 0 \
		   -highlightcolor $menu_col(bg,frame) \
		   -highlightbackground $menu_col(bg,frame) \
		   -highlightthickness 1 ]
}

proc mol_set_dial { i_set molname cmd } {
    global mol_set menu_col

    return [checkbutton $mol_set($i_set,menu).$molname \
		    -variable mol_set($i_set,$molname,flag) \
		    -command $cmd \
		    -anchor center \
		    -indicatoron true \
		    -activebackground $menu_col(bg,frame) \
		    -bg $menu_col(bg,frame) \
		    -activeforeground $menu_col(fg) \
		    -fg $menu_col(fg) \
		    -selectcolor $menu_col(bg,act,1) \
		    -highlightbackground $menu_col(bg,frame) \
		    -highlightthickness 0 ]
}

############################
