##############################################
# Set up the animation scenario for Loop 1:  #
# the first set of animated solution of the  #
# elastic rod problem for the short DNA loop #
##############################################

set mol_set($i_set,max_anim_state) 14

## Elastic Rod ##
set mol_set($i_set,rod,stop_frame,0)  0
set mol_set($i_set,rod,stop_frame,1)  0
set mol_set($i_set,rod,stop_frame,2) 10
set mol_set($i_set,rod,stop_frame,3) 30
set mol_set($i_set,rod,stop_frame,4) 31
for {set i 5} {$i<=11} {incr i} {
    set mol_set($i_set,rod,stop_frame,$i) [expr $i + 27] }
#set mol_set($i_set,rod,stop_frame,5) 38
set mol_set($i_set,rod,stop_frame,12) 39
set mol_set($i_set,rod,stop_frame,13) 40
set mol_set($i_set,rod,stop_frame,14) 50

## Protein-DNA interaction forces ##
set mol_set($i_set,force,stop_frame,0)  0
set mol_set($i_set,force,stop_frame,1)  0
set mol_set($i_set,force,stop_frame,2) 10
set mol_set($i_set,force,stop_frame,3) 30
set mol_set($i_set,force,stop_frame,4) 31
for {set i 5} {$i<=11} {incr i} {
    set mol_set($i_set,force,stop_frame,$i) [expr $i + 27] }
#set mol_set($i_set,force,stop_frame,5) 38
set mol_set($i_set,force,stop_frame,12) 39
set mol_set($i_set,force,stop_frame,13) 40
set mol_set($i_set,force,stop_frame,14) 50

## Electric field ##
for {set i 0} {$i<=4} {incr i} {
    set mol_set($i_set,efield,stop_frame,$i) 0 }
for {set i 5} {$i<=12} {incr i} {
    set mol_set($i_set,efield,stop_frame,$i) [expr $i - 5] }
for {set i 13} {$i<=$mol_set($i_set,max_anim_state)} {incr i} {
    set mol_set($i_set,efield,stop_frame,$i) 7 }

## DNA ##
set mol_set($i_set,dna,stop_frame,0) 0
for {set i 1} {$i<=13} {incr i} {
    set mol_set($i_set,dna,stop_frame,$i) 1 }
set mol_set($i_set,dna,stop_frame,14) 2

## CAP protein ##
for {set i 0} {$i<=14} {incr i} {
    set mol_set($i_set,cap,stop_frame,$i)    0 
}

## SAFETY FEATURE ##
foreach m {dna rod cap force efield} {
    set nfrmax [expr [molinfo $mol_set($i_set,$m) get numframes] - 1]
    foreach {i j} [array get mol_set $i_set,$m,stop_frame,*] {
	  if { $mol_set($i) > $nfrmax } { set mol_set($i) $nfrmax }
    }
}
