/*
 * Copyright (C) 2007 by David J. Hardy.  All rights reserved.
 *
 * timer.h - gather timing statistics
 */

#ifndef TIMER_H
#define TIMER_H

#ifdef __cplusplus
extern "C" {
#endif

  typedef struct Timer_t {
    double seconds;
    double fraction;
  } Timer;

  /* start the timer */
  void timer_start(Timer *);

  /* gives delta in seconds between now and last call to timer_start() */
  double timer_delta(Timer *);

#ifdef __cplusplus
}
#endif

#endif /* TIMER_H */
