/*
 * Copyright (C) 2007 by David J. Hardy.  All rights reserved.
 *
 * gridio.h - read and write binary data file of rectangular grid of floats
 *
 * Grid memory allocation and deallocation routines also provided.
 * Read routine performs grid allocation and corrects for different endianism.
 */

#ifndef GRIDIO_H
#define GRIDIO_H

#define GRIDIO_FAIL  (-1)

#ifdef __cplusplus
extern "C" {
#endif

  int gridio_write(const char *name, float *g, int nx, int ny, int nz);
  float *gridio_read(const char *name, int *nx, int *ny, int *nz);
  float *gridio_alloc(int nx, int ny, int nz);
  void gridio_free(float *g);

#ifdef __cplusplus
}
#endif

#endif /* GRIDIO_H */
