#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <algorithm>
#include <vector>
#include <string>
#include <time.h>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <sstream>
#include <limits.h>

using namespace std;
// /////////////////////////////////////////////////////////////////

#define PI 3.1415926535897932384626433f
#define NINT(x) (int) ((x) > 0 ? ((x) + 0.5) : ((x) - 0.5))
#define INTFLOOR(x) (int) (floor(x + 0.00001))
#define MAX(x, y) ((x) > (y) ? (x) : (y))

const float     MIN_FLOAT = -999999986991104.00;
// Large negative number for initializing float values.
// Defined to overcome compiler specific NAN definitions.
// Note that this float has an exact IEEE-754 representation.


/********************************************************************/
class           TORSION {

  public:

    // //////////////////////////////////////////////////
    int             atom1;      // first atom bound to atom 2 (to define angle)
    int             atom2;      // first atom of rotatable bond
    int             atom3;      // second atom of rotatable bond
    int             atom4;      // first atom bound to atom 3 (to define angle)
    int             bond_num;   // bond number in Mol

};

/*******************************************/
class           XYZCRD {
  public:
    float           x,
                    y,
                    z;

    XYZCRD(float _x = 0.0, float _y = 0.0, float _z = 0.0)
        : x(_x), y(_y), z(_z) {
    };
    ~XYZCRD() {
        x = y = z = 0.0;
    };

    void assign_vals(float a, float b, float c) {
        x = a;
        y = b;
        z = c;
    };
    float distance_squared( const XYZCRD & p ) const {
        return (p.x - x)*(p.x - x) + (p.y - y)*(p.y - y) + (p.z - z)*(p.z - z);
    };
    float distance( const XYZCRD & p ) const {
        return sqrt( distance_squared( p ) );
    };

    XYZCRD & operator=(const XYZCRD & xyz) {
        x = xyz.x;
        y = xyz.y;
        z = xyz.z;
        return (*this);
    };

};

/*******************************************/
class           DOCKVector {

  public:
    float           x;
    float           y;
    float           z;

    DOCKVector      operator=(const DOCKVector &);
                    DOCKVector & operator+=(const DOCKVector &);
                    DOCKVector & operator+=(const float &);
                    DOCKVector & operator-=(const DOCKVector &);
                    DOCKVector & operator-=(const float &);
                    DOCKVector & operator*=(const float &);
                    DOCKVector & operator/=(const float &);
                    DOCKVector & normalize_vector();
    float           length() const;
    float           squared_length() const;
    float           squared_dist(const DOCKVector &) const;

    friend int      operator==(const DOCKVector &, const DOCKVector &);
    friend int      operator!=(const DOCKVector &, const DOCKVector &);

    friend DOCKVector operator+(const DOCKVector &, const DOCKVector &);
    friend DOCKVector operator+(const float &, const DOCKVector &);
    friend DOCKVector operator+(const DOCKVector &, const float &);
    friend DOCKVector operator-(const DOCKVector &, const DOCKVector &);
    friend DOCKVector operator-(const DOCKVector &);
    friend DOCKVector operator-(const DOCKVector &, const float &);
    friend DOCKVector operator*(const DOCKVector &, const DOCKVector &);
    friend DOCKVector operator*(const float &, const DOCKVector &);
    friend DOCKVector operator*(const DOCKVector &, const float &);
    friend DOCKVector operator/(const DOCKVector &, const float &);

    friend float    dot_prod(const DOCKVector &, const DOCKVector &);
    friend DOCKVector cross_prod(const DOCKVector &, const DOCKVector &);
    friend float    get_vector_angle(const DOCKVector &, const DOCKVector &);
    friend float    get_torsion_angle(DOCKVector &, DOCKVector &, DOCKVector &,
                                      DOCKVector &);

};

/*******************************************/
typedef         vector < int >INTVec;
typedef         pair < int, int > INTPair;
typedef         vector < float >FLOATVec;
typedef         vector < XYZCRD > XYZVec;
typedef         vector < INTVec > INTVecVec;
typedef         vector < FLOATVec > FLOATVecVec;
typedef         vector < INTVecVec > INTVecVecVec;

typedef char    STRING20[21];

/******************************************/
class           PARAMETER {

  public:

    string name;
    string          value;
    int             flag;

                    PARAMETER() {
        flag = 0;
    };
    void            clear() {
        name = "";
        value = "";
    };

};

/******************************************/
class           Parameter_Reader {

  public:

    ifstream param_file_in;
    ofstream        param_file_out;
    char            param_file_name[500];
    int             num_missing_params;
    bool            no_stdin;
    int             verbosity;

                    vector < PARAMETER > params_in, params_out;

    void            initialize(int argc, char **argv);
    void            read_params();
    string          query_param(string name, string default_value,
                                string legal_values = "");
    int             verbosity_level();
    int             check_duplicates(PARAMETER & param);
    void            write_params();
    bool            parameter_input_successful();

};


int             check_commandline_flag(char **, int, char *);
int             check_commandline_argument(char **, int, char *);
string          parse_commandline_argument(char **, int, char *);

// extern INTVecVecVec child_list;
// ///////////////////////////////////////////////////////
// extern int *child_list;

int             get_matrix_from_quaternion(float m[3][3], float qin[3]);
