// trace.inl
// implementation of class Trace inline methods
// 
static char Trace_inline[] = "$Id: trace.inl,v 1.1 2006/04/26 03:10:39 sbrozell Exp $" ;

#include <iostream>

inline
Trace::Trace( char const * name )
: theFunctionName( 0 )
{
    if ( isTracingOn() && name != 0 ) {
        std::clog << preamble << "Enter " << name << std::endl ;
        theFunctionName = new std::string( name ) ;
    }
}

inline
Trace::Trace( std::string const & name )
: theFunctionName( 0 )
{
    if ( isTracingOn() ) {
        std::clog << preamble << "Enter " << name << std::endl ;
        theFunctionName = new std::string( name ) ;
    }
}

inline
Trace::~Trace()
{
    if ( isTracingOn() && theFunctionName != 0 ) {
        std::clog << preamble << "Exit " << * theFunctionName << std::endl ;
        delete theFunctionName ;
    }
}

inline
void
Trace::note( char const * message )
const
{
    if ( isTracingOn() && message != 0) {
        std::clog << preamble << message << std::endl ;
    }
}

inline
void
Trace::note( std::string const & message )
const
{
    if ( isTracingOn() ) {
        std::clog << preamble << message << std::endl ;
    }
}

inline
void
Trace::identity( void const * address )
const
{
    if ( isTracingOn() ) {
        std::clog << preamble << "My address is " << address << std::endl ;
    }
}

inline
bool
Trace::isTracingOn( )
{
    return traceIsActive ;
}

inline
void
Trace::traceOff( )
{
    traceIsActive = false ;
}

inline
void
Trace::traceOn( )
{
    traceIsActive = true ;
}

inline
void
Trace::tracing( bool on )
{
    traceIsActive = on ;
}

