using namespace std;

#define VDWOFF -0.09
#define MAX_ATOM_REC 1000
#define MAX_ATOM_LIG 200

#define SQR(x) ((x)*(x))
#define MAX(x, y) ((x) > (y) ? (x) : (y))

/*****************************************************************/
class           COORDS {
  public:
    float           crd[3];
};

typedef         vector < COORDS > CRDVec;

class           INT2000 {
  public:
    int             vals[2000];
};
/*************************************************************/
typedef struct point_def {
    float           v[3];
} POINT;
/*************************************************************/
class           ShortDOCKMol {

  public:

    int             num_atoms;
    POINT          *coord;
    float          *vdw_radius;
    float          *gb_radius;
    float          *gb_scale;
    float          *charges;
    string         *atom_names;

                    ShortDOCKMol();
                    virtual ~ ShortDOCKMol();
    void            allocate_short_arrays(int);

};
/*****************************************************************/
class           GB_Pairwise:public Base_Score {

  public:

    // GB Variable Section ///////////////////////////////
    // Receptor data
    int             gb_rec_total_atoms;
    float           gb_rec_solv_rec;
                    vector < COORDS > gb_rec_coords;
    FLOATVec        gb_rec_radius_eff;
    FLOATVec        gb_rec_charge;
    FLOATVec        gb_rec_inv_a_rec;
    FLOATVec        gb_rec_inv_a;
    FLOATVec        gb_rec_receptor_screen;

    // Ligand data
                    vector < COORDS > gb_lig_coords;
    FLOATVec        gb_lig_radius_eff;
    FLOATVec        gb_lig_sum_lig;
    FLOATVec        gb_lig_inv_a;
    INTVec          gb_lig_flag;

    // Grid data
    float           gb_grid_origin[3];
    float           gb_grid_spacing;
    float           gb_grid_grdcut;
    float           gb_grid_grdcuto;
    float           gb_grid_cutsq;
    float           gb_grid_f_scale;
    int             gb_grid_span[3];
    int             gb_grid_size;

    // control variables
    bool            gb_initialized;

    // SA Variable Section //////////////////////////////
    // Receptor data
    int             sa_rec_total_atoms;
    float           sa_rec_solv_rec;
                    vector < COORDS > sa_rec_coords;
    FLOATVec        sa_rec_radius_eff;
    INTVec          sa_rec_vdwn_rec;
    INTVec          sa_rec_nsphgrid;
    INTVec          sa_rec_nhp;

    int             sa_rec_nsas;
    int             sa_rec_nsas_hp;
    int             sa_rec_nsas_pol;

    // Ligand data
                    vector < INT2000 > sa_grid_mark_sas_lig;
                    vector < COORDS > sa_lig_coords;
    FLOATVec        sa_lig_radius_eff;

    // Grid data
    float           sa_grid_origin[3];
    float           sa_grid_spacing;
    float           sa_grid_grdcut;
    float           sa_grid_grdcuto;
    float           sa_grid_cutsq;
    float           sa_grid_f_scale;
    int             sa_grid_span[3];
    int             sa_grid_size;
    int             sa_grid_nvtyp;

    float           sa_grid_r_probe;
    float           sa_grid_sspacing;
    float           sa_grid_r2_cutoff;
    INTVecVec       sa_grid_mark_sas;
                    vector < CRDVec > sa_grid_sphgrid_crd;

    // VDW calculation section
    Energy_Score    vdw_score;
    string          vdw_grid_prefix;

    // General Variables
    int             use_gbsa;
    string          gb_grid_prefix;
    string          sa_grid_prefix;
    string          screen_file;
    float           solvent_dielectric;
    bool            verbose;
    float           vdw_component;
    float           gb_component;
    float           sa_component;
    float           del_SAS_hp;

    // Functions ////////////////////////////////////////////
    void            input_parameters(Parameter_Reader & parm,
                                     bool & primary_score,
                                     bool & secondary_score);
    void            initialize(AMBER_TYPER & typer);
    bool            compute_score(DOCKMol & mol);
    string          output_score_summary(float);

    void            read_gb_receptor_grid();
    float           get_gb_solvation_score(DOCKMol & mol);

    void            read_sa_receptor_grid();
    float           get_sa_solvation_score(DOCKMol & mol);
};/************************************************/
class           GB_Hawkins:public Base_Score {

  public:

    // parameters
    string rec_filename;
    bool            salt_screen,
                    cont_vdw;
    float           gb_offset,
                    salt_conc,
                    espout;
    bool            verbose;

    // data structures for solvation
    DOCKMol         receptor;
    ShortDOCKMol    short_rec,
                    short_lig,
                    short_com;
    Energy_Score    vdw_score;

    // structures for GB
    float           kappa,
                    gfac;
    float           gpol_rec,
                    gpol_lig,
                    gpol_com;

    float          *born_radius_rec,
                   *born_radius_lig,
                   *born_radius_com;
    float          *rec_dist_mat,
                   *lig_dist_mat,
                   *com_dist_mat;

    // SASA Portion
    float           rec_sasa,
                    lig_sasa,
                    com_sasa;
    float           gnpol_rec,
                    gnpol_lig,
                    gnpol_com;
    // internal data for VDW & ES score
    float           vdw_component,
                    es_component;
    float           total_score;

    // GB Portion
    void            born_array_calc(ShortDOCKMol &, float, float *, float *);
    float           gpol_calc(ShortDOCKMol &, float *, float *, bool, float,
                              float, float);

    // Energy Scoring
                    GB_Hawkins();
                    virtual ~ GB_Hawkins();
    void            input_parameters(Parameter_Reader & parm,
                                     bool & primary_score,
                                     bool & secondary_score);
    void            initialize(AMBER_TYPER &);

    void            prepare_receptor();
    bool            prepare_ligand(DOCKMol &);
    void            prepare_complex(DOCKMol &);

    bool            compute_score(DOCKMol &);
    string          output_score_summary(float);

};
/************************************************/
class           PBSA_Score:public Base_Score {

  public:

    // parameters for pbsa calculation
    float           salt_conc,
                    espin,
                    espout;
    int             zhandle;
    int             ligand_handle,
                    protein_handle,
                    complex_handle;
    float           prot_solv,
                    prot_area;
    float           lig_solv,
                    lig_area;
    float           comp_solv,
                    comp_area;
    bool            verbose;
    string          rec_filename;
    DOCKMol         receptor;
    Energy_Score    vdw_score;
    string          vdw_grid_prefix;

    // parameters to summarize energy components
    float           pb_component;
    float           vdw_component;
    float           sa_component;
    float           current_score;

    // general scoring functions
    void            input_parameters(Parameter_Reader & parm,
                                     bool & primary_score,
                                     bool & secondary_score);
    void            initialize(AMBER_TYPER &);
    bool            compute_score(DOCKMol & mol);
    string          output_score_summary(float);

    // PBSA specific functions
    float           process_molecule(DOCKMol &, int);
    void            process_complex();

};
