using namespace std;


/*****************************************************************/
class           Master_Score {

  public:
    Energy_Score c_nrg;
    Chemgrid_Score  c_cmg;      // kxr & bks scoring 
    Continuous_Energy_Score c_cont_nrg;
    Contact_Score   c_cnt;
    GB_Pairwise     c_gbsa;
    GB_Hawkins      c_gbsa_hawkins;
    PBSA_Score      c_pbsa;
    Amber_Score     c_amber;

    Base_Score     *primary_score;
    Base_Score     *secondary_score;

    bool            primary_score_found;
    bool            secondary_score_found;

    bool            use_primary_score;
    bool            use_secondary_score;
    bool            use_score;
    bool            read_gb_parm;
    bool            primary_min;
    bool            secondary_min;
    bool            read_vdw;
    bool            amber;

    void            input_parameters(Parameter_Reader & parm);
    void            initialize_all(AMBER_TYPER &, bool internal_min, int argc,
                                   char **argv);
    bool            compute_primary_score(DOCKMol & mol);
    bool            compute_secondary_score(DOCKMol & mol);

};
