#include "dock.h"

/******************************************************/
void
Master_Score::input_parameters(Parameter_Reader & parm)
{
    string          tmp;

    primary_score_found = false;
    secondary_score_found = false;
    use_primary_score = false;
    use_secondary_score = false;

    // flags for whether other portions of code should be
    // activated depending on scoring function
    read_gb_parm = false;
    primary_min = false;
    secondary_min = false;
    read_vdw = false;
    amber = false;

    cout << "\nMaster Score Parameters" << endl;
    cout <<
        "------------------------------------------------------------------------------------------"
        << endl;

    tmp = parm.query_param("score_molecules", "yes", "yes no");

    if (tmp == "yes")
        use_score = true;
    else
        use_score = false;

    if (use_score) {

        c_cnt.use_score = false;
        c_cnt.use_primary_score = false;
        c_cnt.use_secondary_score = false;
        c_nrg.use_score = false;
        c_nrg.use_primary_score = false;
        c_nrg.use_secondary_score = false;
        c_cmg.use_score = false;
        c_cmg.use_primary_score = false;
        c_cmg.use_secondary_score = false;
        c_cont_nrg.use_score = false;
        c_cont_nrg.use_primary_score = false;
        c_cont_nrg.use_secondary_score = false;
        c_gbsa.use_score = false;
        c_gbsa.use_primary_score = false;
        c_gbsa.use_secondary_score = false;
        c_gbsa_hawkins.use_score = false;
        c_gbsa_hawkins.use_primary_score = false;
        c_gbsa_hawkins.use_secondary_score = false;
        c_pbsa.use_score = false;
        c_pbsa.use_primary_score = false;
        c_pbsa.use_secondary_score = false;
        c_amber.use_score = false;
        c_amber.use_primary_score = false;
        c_amber.use_secondary_score = false;



        if ((!primary_score_found) || (!secondary_score_found)) {
            c_cnt.input_parameters(parm, primary_score_found,
                                   secondary_score_found);

            if (c_cnt.use_primary_score) {
                primary_score = &c_cnt;
                primary_min = true;
                read_vdw = true;
            }
            if (c_cnt.use_secondary_score) {
                secondary_score = &c_cnt;
                secondary_min = true;
                read_vdw = true;
            }
        }

        if ((!primary_score_found) || (!secondary_score_found)) {
            c_nrg.input_parameters(parm, primary_score_found,
                                   secondary_score_found);

            if (c_nrg.use_primary_score) {
                primary_score = &c_nrg;
                primary_min = true;
                read_vdw = true;
            }
            if (c_nrg.use_secondary_score) {
                secondary_score = &c_nrg;
                secondary_min = true;
                read_vdw = true;
            }
        }

        if ((!primary_score_found) || (!secondary_score_found)) {
            c_cmg.input_parameters(parm, primary_score_found,
                                   secondary_score_found);

            if (c_cmg.use_primary_score) {
                primary_score = &c_cmg;
                primary_min = true;
                read_vdw = true;
            }
            if (c_cmg.use_secondary_score) {
                secondary_score = &c_cmg;
                secondary_min = true;
                read_vdw = true;
            }
        }

        if ((!primary_score_found) || (!secondary_score_found)) {
            c_cont_nrg.input_parameters(parm, primary_score_found,
                                        secondary_score_found);

            if (c_cont_nrg.use_primary_score) {
                primary_score = &c_cont_nrg;
                primary_min = true;
                read_vdw = true;
            }
            if (c_cont_nrg.use_secondary_score) {
                secondary_score = &c_cont_nrg;
                secondary_min = true;
                read_vdw = true;
            }
        }

        if ((!primary_score_found) || (!secondary_score_found)) {
            c_gbsa.input_parameters(parm, primary_score_found,
                                    secondary_score_found);

            if (c_gbsa.use_primary_score) {
                primary_score = &c_gbsa;
                primary_min = true;
                read_vdw = true;
            }
            if (c_gbsa.use_secondary_score) {
                secondary_score = &c_gbsa;
                secondary_min = true;
                read_vdw = true;
            }
        }

        if ((!primary_score_found) || (!secondary_score_found)) {
            c_gbsa_hawkins.input_parameters(parm, primary_score_found,
                                            secondary_score_found);

            if (c_gbsa_hawkins.use_primary_score) {
                primary_score = &c_gbsa_hawkins;
                primary_min = true;
                read_vdw = true;
                read_gb_parm = true;
            }
            if (c_gbsa_hawkins.use_secondary_score) {
                secondary_score = &c_gbsa_hawkins;
                secondary_min = true;
                read_vdw = true;
                read_gb_parm = true;
            }
        }
#ifdef BUILD_DOCK_WITH_ZAP
        if ((!primary_score_found) || (!secondary_score_found)) {
            c_pbsa.input_parameters(parm, primary_score_found,
                                    secondary_score_found);

            if (c_pbsa.use_primary_score) {
                primary_score = &c_pbsa;
                primary_min = true;
                read_vdw = true;
            }
            if (c_pbsa.use_secondary_score) {
                secondary_score = &c_pbsa;
                secondary_min = true;
                read_vdw = true;
            }
        }
#endif

        if ((!primary_score_found) || (!secondary_score_found)) {
            c_amber.input_parameters(parm, primary_score_found,
                                     secondary_score_found);
            if (c_amber.use_primary_score) {
                primary_score = &c_amber;
                amber = true;
            }
            if (c_amber.use_secondary_score) {
                secondary_score = &c_amber;
                amber = true;
            }
        }

        if (!primary_score_found) {
            cout <<
                "\nError:  No scoring function selected for the primary score.  Program will now terminate.\n"
                << endl;
            exit(0);
        } else
            use_primary_score = true;

        if (!secondary_score_found) {
            cout << "\nWarning:  No secondary scoring function selected.\n" <<
                endl;
        } else
            use_secondary_score = true;

    } else {
        use_primary_score = false;
        use_secondary_score = false;
    }

}

/******************************************************/
void
Master_Score::initialize_all(AMBER_TYPER & typer, bool internal_min, int argc,
                             char **argv)
{

    if (use_primary_score) {

        if (c_cnt.use_score == true) {
            c_cnt.initialize();
        }

        if (c_nrg.use_score == true) {
            c_nrg.initialize(typer);
        }

        if (c_cmg.use_score == true) {
            c_cmg.initialize(typer);
        }

        if (c_cont_nrg.use_score == true) {
            c_cont_nrg.initialize(typer);
        }

        if (c_gbsa.use_score == true) {
            c_gbsa.initialize(typer);
        }

        if (c_gbsa_hawkins.use_score == true) {
            c_gbsa_hawkins.initialize(typer);
        }

        if (c_amber.use_score == true) {
            c_amber.initialize(typer);
        }

        if (c_pbsa.use_score == true) {
            c_pbsa.initialize(typer);
        }



    }

}
/******************************************************/
bool
Master_Score::compute_primary_score(DOCKMol & mol)
{

    if (use_primary_score)
        return primary_score->compute_score(mol);
    else
        return true;

}
/******************************************************/
bool
Master_Score::compute_secondary_score(DOCKMol & mol)
{

    if (use_secondary_score)
        return secondary_score->compute_score(mol);
    else
        return true;

}
