using namespace std;

typedef         vector < float >TOR_LIST;

/***********************************/
class           DOCKMol {

  public:

    // Molecule General Info
    string title;
    string          mol_info_line;
    string          comment1;
    string          comment2;
    string          comment3;
    string          energy;
    string          score_text_data;
    string          mol_data;   // misc data

    // Molecule Size and Property Info
    int             num_atoms;
    int             num_bonds;
    float           total_dsol; // kxr


    bool            arrays_allocated;

    // atom information
    string         *atom_data;  // misc data

    float          *x;
    float          *y;
    float          *z;

    float          *charges;
    string         *atom_types;
    string         *atom_names;
    string         *subst_names;
    string         *atom_color; // kxr205
    float          *atom_psol;  // kxr205
    float          *atom_apsol; // kxr205

    // bond information
    int            *bonds_origin_atom;
    int            *bonds_target_atom;
    string         *bond_types;

    // ring info
    bool           *atom_ring_flags;
    bool           *bond_ring_flags;

    // activation info
    int             num_active_atoms;
    int             num_active_bonds;
    bool           *atom_active_flags;
    bool           *bond_active_flags;

    // AMBER atom type info
    bool            amber_at_assigned;
    int            *amber_at_id;
    float          *amber_at_radius;
    float          *amber_at_well_depth;
    int            *amber_at_heavy_flag;
    int            *amber_at_valence;
    int            *amber_at_bump_id;

    // Pharmacophore Type info
    bool            chem_types_assigned;
    string         *chem_types;

    // AMBER bond type info
    bool            amber_bt_assigned;
    int            *amber_bt_id;
    int            *amber_bt_minimize;
    int            *amber_bt_torsion_total;
    FLOATVec       *amber_bt_torsions;

    // GB radius & scale factor
    float          *gb_hawkins_radius;
    float          *gb_hawkins_scale;

    // Amber Score Identity
    string          amber_score_ligand_id;

    // General scoring information
    float           current_score;
    string          current_data;
    string            primary_data;

    // Neighbor lists
    INTVec         *neighbor_list;
    // bool *ie_neighbor_list;
    INTVec         *atom_child_list;    // list of children atoms for each bond 
                                        // in mol (2x#bonds- for
                                        // directionality)

    // Internal Energy members
    // bool use_internal_energy;
    // int att_exp;
    // int rep_exp;
    // float dielectric;

    // General DOCK Functions
    void           input_parameters(Parameter_Reader & parm);
    void           initialize();
    void           allocate_arrays(int, int);
    void           clear_molecule();
    vector < int > get_atom_neighbors(int);
    vector < int > get_bond_neighbors(int);
    int            get_bond(int, int);
    void           id_ring_atoms_bonds();
    void           find_rings(vector < int >, vector < int >,
                              vector < bool > &, vector < bool > &, int);
    bool           bond_is_rotor(int index) {return amber_bt_id[index] != -1;};
    vector < int > get_atom_children(int, int);
    float          get_torsion(int, int, int, int);
    void           set_torsion(int, int, int, int, float);
    void           translate_mol(const DOCKVector & vec);
    void           rotate_mol(float mat[9]);
    void           rotate_mol(float mat[3][3]);
    bool           atoms_are_one_three(int, int);
    bool           atoms_are_one_four(int, int);
    void           prepare_molecule();
    void           setcharges(const double* charges, double units_factor = 1.0);
    void           setxyz( const double * xyz );

    void           operator=(const DOCKMol & mol);

    DOCKMol();
    DOCKMol(const DOCKMol &);
    ~DOCKMol();

};

/**************************************************/
class           RANKMol {
  public:
    DOCKMol mol;
    float           score;
    string          data;

    void            clear_molecule() {
        mol.clear_molecule();
        score = 0.0;
        data = "";
    };
    int             operator<(RANKMol x) const {
        return (score < x.score);
    };

};

/********************************************************************/
class           BREADTH_SEARCH {

  public:

    INTVec atoms;
    INTVec          nbrs;
    INTVec          nbrs_next;

    int             get_search_radius(DOCKMol &, int, int);

};

typedef         pair < float,
                DOCKMol > SCOREMol;
int             less_than_pair(SCOREMol a, SCOREMol b);

bool            Read_Mol2(DOCKMol &, istream &, bool, bool, bool);
bool            Write_Mol2(DOCKMol &, ostream &);
void            copy_molecule(DOCKMol &, const DOCKMol &);
void            copy_crds(DOCKMol &, DOCKMol &);
void            transform(DOCKMol &, float rmat[3][3], DOCKVector, DOCKVector);
/*****************************************************************/
