# DOCK default macros, rules and targets for test Makefiles.

DOCK=dock6
DOCK_BIN=../../../bin
DOCK_VERSION=`cat ../../src/dock/version.h | grep DOCK_VERSION | cut -d'"' -f2`
RELATIVE_DOCK_HOME=../../..
SHELL = /bin/sh


# This is the default target.
all: test


# Create Amber_Dock input files for a combined receptor ligand complex.
amberize: 
	$(DOCK_BIN)/prepare_amber.pl $(LIG) $(REC)

# there is no dock target;
# instead the .dockin.dockout inference rule is used; see below.

grid:
	# Compute scoring grids
	$(DOCK_BIN)/grid -i grid.in -o grid.out
	../dockdif grid.out.save grid.out

nchemgrid_GB:
	@# Calculate grids for Zou GB 
	@echo "Calculating GB grid for Zou GB/SA"
	$(DOCK_BIN)/nchemgrid_GB > /dev/null
	../dockdif -w -t 4 OUTCHEM.save OUTCHEM
	../dockdif OUTPARM.save OUTPARM

nchemgrid_SA:
	@# Calculate grids for Zou SA
	@echo "Calculating SA grid for Zou GB/SA"
	$(DOCK_BIN)/nchemgrid_SA
	../dockdif -w -t 1 OUTCHEM.save OUTCHEM
	../dockdif OUTPARM.save OUTPARM

rec.prmtop: rec.pdb
	make amberize

showbox:
	# Construct box to enclose spheres
	$(DOCK_BIN)/showbox < box.in > /dev/null
	../dockdif box.pdb.save box.pdb

showsphere:
	# Convert selected spheres into pdb format for viewing
	$(DOCK_BIN)/showsphere < select.in > /dev/null
	../dockdif selected_cluster.pdb.save selected_cluster.pdb

sphgen:
	# Construct sphere set in active site
	$(DOCK_BIN)/sphgen
	../dockdif OUTSPH.save OUTSPH

sphere_selector:
	# Select spheres within 10 Ang of ligand 
	$(DOCK_BIN)/sphere_selector struct.sph lig.mol2 3.0
	../dockdif -t 3 selected_spheres.sph.save selected_spheres.sph

chemgrid_generation:
	# generate dock3.5.54 chemgrids used by dock6
	$(DOCK_BIN)/chemgrid
	../dockdif OUTCHEM.save OUTCHEM

delphi_grid_generation:
	# generate DelPhi grid to be used by dock6
	$(DOCK_BIN)/make_phimap $(DELPHI_PATH) 1> delphi.out
	../dockdif -w -t 1 delphi.out.save delphi.out

solvgrid_generation:
	# generate dock3.5.54 solvgrids used by dock6
	../../../bin/solvmap
	../dockdif solvmap.save solvmap
	../dockdif -w -t 1 OUTSOLV.save OUTSOLV
	../../../bin/solvgrid
	../dockdif -w -t 1 OUTRDSL.save OUTRDSL

grid_convert:
	# convert dock3.5.54 chemgrids to dock6 chemgrids
	../../../bin/grid-convert -i gconv.in 1> gconv.out 2>&1
	../dockdif gconv.out.save gconv.out

grid_convrds:
	# convert dock3.5.54 chemgrids and solvation grids
	../../../bin/grid-convrds -i gconv.in 1> gconv.out 2>&1
	../dockdif gconv.out.save gconv.out

# Error checking and reporting.
parallel_dock_exists:
	@# abort if the parallel dock executable does not exist
	@(if [ ! -x "$(DOCK_BIN)/$(DOCK).mpi" ] ; then \
	    echo "" ;\
	    echo "The parallel dock executable does not exist." ;\
	    echo "    Skipping this test." ;\
	    echo "" ;\
	    exit 3 ;\
	fi ;\
	)


# Find and emit the dif files.
check:
	@(find . -name "*.dif" ! -size 0c -print | \
	while read dif ;\
	do \
	    echo $$dif ;\
	    cat $$dif ;\
	    echo ;\
	done ;\
	)

# Find and list the dif files.
check_ls:
	@(find . -name "*.dif" ! -size 0c -print | \
	while read dif ;\
	do \
	    echo $$dif ;\
	done ;\
	)


# Clean targets follow the naming rule clean_program_family_name.
clean_amberize:
	/bin/rm -f amberize_complex.*.out amberize_ligand.*.out amberize_rec.out \
	*.log *.inpcrd *.prmtop *.frcmod *.amber.pdb lig.*.mopac.out lig.*.mol2 \
	output_scored.mol2 lig.gaff.mol2 *.amber_score.mol2 \
	t4lys_mutant_multiple.1.* t4lys_mutant_multiple.2.* \
	tleap.in tleap.out *.dif

clean_dock:
	/bin/rm -f *.dif *.dockout

clean_grid:
	/bin/rm -f grid.bmp grid.cnt grid.nrg grid.out grid.out.dif

clean_nchemgrid_GB:
	/bin/rm -f OUTCHEM OUTPARM PDBPARM NEG_INVA PDBCAV inva screen.para \
		zou_grid.* OUTCHEM.dif OUTPARM.dif

clean_nchemgrid_SA:
	/bin/rm -f OUTCHEM OUTPARM PDBPARM \
		zou_grid.* OUTCHEM.dif OUTPARM.dif

clean_showbox:
	/bin/rm -f box.pdb box.pdb.dif

clean_showsphere:
	/bin/rm -f selected_cluster.pdb selected_cluster.pdb.dif

clean_sphere_selector:
	/bin/rm -f selected_spheres.sph selected_spheres.sph.dif

clean_sphgen:
	/bin/rm -f temp1.ms temp2.sph temp3.atc OUTSPH struct.sph OUTSPH.dif

clean_chemgrid_generation:
	/bin/rm -f OUTCHEM OUTPARM PDBPARM chem.*

clean_delphi_grid_generation:
	/bin/rm -f rec+sph.phi delphi.out delphi.out.dif

clean_solvgrid_generation:
	/bin/rm -f OUTSOLV solvmap distmap.box OUTRDSL OUTPARM PDBPARM \
	chem.bmp chem.dsl chem.esp chem.vdw solvmap.dif OUTSOLV.dif OUTRDSL.dif

clean_grid_convert:
	/bin/rm -f gconv.out gconv.out.dif \
	chem52.bmp chem52.chm chem52.cmg chem52.dsl chem52.phi

clean_grid_convrds:
	/bin/rm -f gconv.out gconv.out.dif \
	chem52.bmp chem52.chm chem52.cmg chem52.dsl chem52.phi


.SUFFIXES:
.SUFFIXES:  .dockin .dockout .dif .dockmpiout .dockpbsaout

# Inference rule to create a DOCK output file of extension .dockout from
# a DOCK input file of extension .dockin
.dockin.dockout: 
	@echo
	@echo "Processing test $*"
	$(DOCK_BIN)/$(DOCK) -i $< -o $@ 
	../dockdif -t 8 $@.save $@
	@( \
	if [ -f $*_conformers.mol2 ] ; then \
	   ../dockdif -t 8 $*_conformers.mol2.save $*_conformers.mol2 ;\
	fi ;\
	if [ -f $*_orients.mol2 ] ; then \
	   ../dockdif -t 8 $*_orients.mol2.save $*_orients.mol2 ;\
	fi ;\
	if [ -f $*_ranked.mol2 ] ; then \
	   ../dockdif -t 8 $*_ranked.mol2.save $*_ranked.mol2 ;\
	fi ;\
	if [ -f $*_scored.mol2 ] ; then \
	   ../dockdif -t 8 $*_scored.mol2.save $*_scored.mol2 ;\
	fi ;\
    if [ -f $*_primary_conformers.mol2 ] ; then \
	   ../dockdif -t 8 $*_primary_conformers.mol2.save $*_primary_conformers.mol2 ;\
	fi ;\
    if [ -f $*_secondary_conformers.mol2 ] ; then \
	   ../dockdif -t 8 $*_secondary_conformers.mol2.save $*_secondary_conformers.mol2 ;\
	fi ;\
    if [ -f $*_primary_scored.mol2 ] ; then \
	   ../dockdif -t 8 $*_primary_scored.mol2.save $*_primary_scored.mol2 ;\
	fi ;\
    if [ -f $*_secondary_scored.mol2 ] ; then \
	   ../dockdif -t 8 $*_secondary_scored.mol2.save $*_secondary_scored.mol2 ;\
	fi ;\
    if [ -f $*_primary_ranked.mol2 ] ; then \
	   ../dockdif -t 8 $*_primary_ranked.mol2.save $*_primary_ranked.mol2 ;\
	fi ;\
    if [ -f $*_secondary_ranked.mol2 ] ; then \
	   ../dockdif -t 8 $*_secondary_ranked.mol2.save $*_secondary_ranked.mol2 ;\
	fi ;\
	)

# Inference rule to create a DOCK output file of extension .dockmpiout from
# a DOCK input file of extension .dockin
.dockin.dockmpiout: 
	@echo
	@echo "Processing test $*"
	$(MPICH_HOME)/bin/mpirun -np 2 $(DOCK_BIN)/$(DOCK).mpi -i $< -o $@ 
	../dockdif -t 8 $@.save $@
	@( \
	if [ -f $*_conformers.mol2 ] ; then \
	   ../dockdif -t 8 $*_conformers.mol2.save $*_conformers.mol2 ;\
	fi ;\
	if [ -f $*_orients.mol2 ] ; then \
	   ../dockdif -t 8 $*_orients.mol2.save $*_orients.mol2 ;\
	fi ;\
	if [ -f $*_ranked.mol2 ] ; then \
	   ../dockdif -t 8 $*_ranked.mol2.save $*_ranked.mol2 ;\
	fi ;\
	if [ -f $*_scored.mol2 ] ; then \
	   ../dockdif -t 8 $*_scored.mol2.save $*_scored.mol2 ;\
	fi ;\
    if [ -f $*_primary_conformers.mol2 ] ; then \
	   ../dockdif -t 8 $*_primary_conformers.mol2.save $*_primary_conformers.mol2 ;\
	fi ;\
    if [ -f $*_secondary_conformers.mol2 ] ; then \
	   ../dockdif -t 8 $*_secondary_conformers.mol2.save $*_secondary_conformers.mol2 ;\
	fi ;\
    if [ -f $*_primary_scored.mol2 ] ; then \
	   ../dockdif -t 8 $*_primary_scored.mol2.save $*_primary_scored.mol2 ;\
	fi ;\
    if [ -f $*_secondary_scored.mol2 ] ; then \
	   ../dockdif -t 8 $*_secondary_scored.mol2.save $*_secondary_scored.mol2 ;\
	fi ;\
    if [ -f $*_primary_ranked.mol2 ] ; then \
	   ../dockdif -t 8 $*_primary_ranked.mol2.save $*_primary_ranked.mol2 ;\
	fi ;\
    if [ -f $*_secondary_ranked.mol2 ] ; then \
	   ../dockdif -t 8 $*_secondary_ranked.mol2.save $*_secondary_ranked.mol2 ;\
	fi ;\
	)

# Inference rule to create a DOCK output file of extension .dockpbsaout from
# a DOCK input file of extension .dockin
.dockin.dockpbsaout: 
	@echo
	@echo "Processing test $*"
	$(DOCK_BIN)/$(DOCK).pbsa -i $< -o $@ 
	../dockdif -t 8 $@.save $@
	@( \
	if [ -f $*_conformers.mol2 ] ; then \
	   ../dockdif -t 8 $*_conformers.mol2.save $*_conformers.mol2 ;\
	fi ;\
	if [ -f $*_orients.mol2 ] ; then \
	   ../dockdif -t 8 $*_orients.mol2.save $*_orients.mol2 ;\
	fi ;\
	if [ -f $*_ranked.mol2 ] ; then \
	   ../dockdif -t 8 $*_ranked.mol2.save $*_ranked.mol2 ;\
	fi ;\
	if [ -f $*_scored.mol2 ] ; then \
	   ../dockdif -t 8 $*_scored.mol2.save $*_scored.mol2 ;\
	fi ;\
    if [ -f $*_primary_conformers.mol2 ] ; then \
	   ../dockdif -t 8 $*_primary_conformers.mol2.save $*_primary_conformers.mol2 ;\
	fi ;\
    if [ -f $*_secondary_conformers.mol2 ] ; then \
	   ../dockdif -t 8 $*_secondary_conformers.mol2.save $*_secondary_conformers.mol2 ;\
	fi ;\
    if [ -f $*_primary_scored.mol2 ] ; then \
	   ../dockdif -t 8 $*_primary_scored.mol2.save $*_primary_scored.mol2 ;\
	fi ;\
    if [ -f $*_secondary_scored.mol2 ] ; then \
	   ../dockdif -t 8 $*_secondary_scored.mol2.save $*_secondary_scored.mol2 ;\
	fi ;\
    if [ -f $*_primary_ranked.mol2 ] ; then \
	   ../dockdif -t 8 $*_primary_ranked.mol2.save $*_primary_ranked.mol2 ;\
	fi ;\
    if [ -f $*_secondary_ranked.mol2 ] ; then \
	   ../dockdif -t 8 $*_secondary_ranked.mol2.save $*_secondary_ranked.mol2 ;\
	fi ;\
	)


# This special target declares these targets as phony, ie, not based on
# files with that name; it avoids problems when such files do exist.
.PHONY:  all check check_ls clean clean_dock clean_grid \
         clean_nchemgrid_GB clean_nchemgrid_SA clean_showbox clean_showsphere \
         clean_sphere_selector clean_sphgen \
         dock grid nchemgrid_GB nchemgrid_SA showbox showsphere \
         sphere_selector sphgen \
         move parallel realclean test uninstall

