###############################################################
# VMD_SS 1.0                                                  #
# REQUIREMENTS: VMD Version *.* or greater                    #
#                                                             #
# DESCRIPTION:                                                #
#    This script is quick and easy to provide procedure       #
# for computing the Secondary Structure of Protein and allows #
# Users to select regions of protein and molid and determine  #
# the output file                                             #
#                                                             #   
# EXAMPLE USAGE:                                              #
#         source VMD_SS.tcl                                   #
#         vmd_ss "chain A" 0 outfile                          #
#                                                             #
#   AUTHORS:                                                  #
#	Sajad Falsafi (sajad.falsafi@yahoo.com)               #
#       Zahra Karimi                                          # 
#       26 May 2011                                           #
###############################################################
proc vmd_ss {selection molid output} {
   set outfile [open $output.dat w];                                             
   set list1 [set SS [[atomselect $molid "$selection and alpha"] get structure]]
# set
   set numT [llength [lsearch -all $list1 T]]
   set numE [llength [lsearch -all $list1 E]]
   set numB [llength [lsearch -all $list1 B]]
   set numH [llength [lsearch -all $list1 H]]
   set numG [llength [lsearch -all $list1 G]]
   set numI [llength [lsearch -all $list1 I]]
   set numC [llength [lsearch -all $list1 C]]
   set numM [expr $numT+$numE+$numB+$numH+$numG+$numI+$numC]
# Print 
      puts $outfile "Secondary structure of : $selection\n"
      puts $outfile "Turn:                   $numT, ([expr ($numT./$numM.)*100]%)"
      puts $outfile "Extended:               $numE, ([expr ($numE./$numM.)*100]%)"
      puts $outfile "Isolated-bridge:        $numB, ([expr ($numB./$numM.)*100]%)"
      puts $outfile "Alpha-helix:            $numH, ([expr ($numH./$numM.)*100]%)"
      puts $outfile "3-10-helix:             $numG, ([expr ($numG./$numM.)*100]%)"
      puts $outfile "Pi-helix:               $numI, ([expr ($numI./$numM.)*100]%)"
      puts $outfile "Coil:                   $numC, ([expr ($numC./$numM.)*100]%)"
      puts $outfile "Total:                  $numM, ([expr ($numM./$numM.)*100]%)"
close $outfile
}


