    # Here for all actions we're defining legal parameters,
    # the types of the corresponding values,
    # and the default values that should appear in the popup
    # TODO add optional RANGE
set ::molywood::actions {
    add_audio {
        params {audiofile from length volume}
        types {audiofile string from float length float volume float}
        defaults {from 0.0 volume 1.0}
        color khaki
        alwayson {audiofile ""}
        abbr addaud
        unpack false
        secondary {volume}
    }
    add_distance {
        params {selection1 selection2 label_color text_size alias}
        types {selection1 string selection2 string label_color string text_size int alias string}
        defaults {label_color "black" text_size 1}
        color bisque2
        alwayson {selection1 "" selection2 ""}
        abbr adddist
        unpack false
        secondary {}
    }
    add_label {
        params {label atom_index label_color text_size alias offset}
        types {label string atom_index int label_color string text_size int alias string offset string}
        defaults {label_color "black" text_size 1}
        color bisque3
        alwayson {label "" atom_index ""}
        abbr addlabl
        unpack false
        secondary {offset}
    }
    add_overlay {
        params {origin relative_size aspect_ratio mode alias sigmoid abruptness alpha transparent_background dataframes datafile dataframes_from_file seaborn 2D text textsize textcolor textbox decimal_points scene figure movie center t}
        types {t float origin string relative_size string aspect_ratio float mode sel alias string sigmoid sel abruptness float alpha string transparent_background boolean dataframes string datafile dfile dataframes_from_file string seaborn boolean 2D boolean text string textsize float textcolor string textbox string decimal_points int scene string figure string movie string center boolean}
        defaults {origin "0,0" relative_size 1.0 aspect_ratio 1.0 mode "ud" sigmoid "t" abruptness 1.0 transparent_background t seaborn f textsize 1 textcolor "black" textbox f decimal_points 3 center f}
        color gold
        alwayson {origin "" relative_size ""}
        abbr addovrl
        unpack false
        secondary {seaborn 2D dataframes_from_file sigmoid abruptness decimal_points}
    }
    align_to_axis {
        params {selection axis invert molecules t}
        types {selection string axis string t float invert boolean molecules string}
        defaults {selection "protein" invert f molecules "all" t 3}
        color lavender
        alwayson {selection ""}
        abbr alignax
        unpack_actions {fit_trajectory ""}
        params_assign {selection fit_trajectory axis fit_trajectory invert fit_trajectory molecules fit_trajectory t fit_trajectory}
        unpack true
        secondary {invert molecules}
    }
    animate {
        params {frames smooth molecules ignore t}
        types {frames string molecules string smooth int ignore boolean t float}
        defaults {frames "0:last" smooth 1 ignore 0 t 3}
        color "sky blue"
        alwayson {frames ""}
        abbr animate
        unpack false
        secondary {molecules ignore}
    }
    center_view {
        params {selection molecules}
        types {selection string molecules string}
        defaults {selection "all" molecules "all"}
        color black
        alwayson {selection ""}
        abbr cview
        unpack false
        secondary {molecules}
    }
    do_nothing {
        params {t}
        types {t float}
        defaults {t 3}
        color white
        alwayson {}
        abbr pause
        unpack false
        secondary {}
    }
    edit_highlight {
        params {selection color mode material isovalue smooth alpha style cutoff fade_in fade_out thickness contour volume_offset alias molecules inline_parameter multiframe t}
        types {selection string color string mode sel material sel isovalue string smooth int alpha string style sel cutoff float fade_in float fade_out float thickness string contour string volume_offset float alias string molecules string inline_parameter string multiframe string t float}
        defaults {mode "n" molecules "all" alias "_ref0" t 3}
        color thistle2
        alwayson {selection "" color "" alias ""}
        abbr edithl
        unpack_actions {highlight ""}
        params_assign {selection highlight color highlight mode highlight material highlight isovalue highlight smooth highlight alpha highlight style highlight cutoff highlight fade_in highlight fade_out highlight thickness highlight contour highlight volume_offset highlight alias highlight molecules highlight inline_parameter highlight multiframe highlight t highlight}
        unpack true
        secondary {isovalue volume_offset molecules inline_parameter multiframe}
    }
    fit_trajectory {
        params {selection axis invert molecules selection_ref molecule_ref t}
        types {selection string axis string t float invert boolean molecules string selection_ref string molecule_ref string}
        defaults {selection "all" invert f molecules "all" t 3}
        color lavender
        alwayson {selection ""}
        abbr fittraj
        unpack false
        secondary {molecules selection_ref molecule_ref}
    }
    highlight {
        params {selection color mode material isovalue smooth alpha style cutoff fade_in fade_out thickness contour volume_offset alias molecules inline_parameter multiframe t}
        types {selection string color string mode sel material sel isovalue string smooth int alpha string style sel cutoff float fade_in float fade_out float thickness string contour string volume_offset float alias string molecules string inline_parameter string multiframe string t float}
        defaults {selection "all" color "type" mode "u" material "Opaque" alpha 1.0 smooth 0 style "newcartoon" cutoff 1.6 fade_in 0.2 fade_out 0.2 thickness 1.0 molecules "all" t 3}
        color thistle2
        alwayson {selection "" color ""}
        abbr hghlt
        unpack false
        secondary {isovalue volume_offset molecules inline_parameter multiframe}
    }
    insert_tcl {
        params {code file loopover range loop_command t}
        types {code string file string loopover string range string loop_command string t float}
        defaults {t 3}
        color pink1
        alwayson {}
        abbr instcl
        unpack false
        secondary {loopover range loop_command}
    }
    make_opaque {
        params {material sigmoid abruptness start limit fraction t}
        types {material sel sigmoid sel abruptness float start float limit float t float fraction string}
        defaults {material Opaque sigmoid "t" abruptness 1.0 start 0.0 limit 1.0 t 3}
        color "light blue"
        alwayson {material ""}
        abbr opaque
        unpack false
        secondary {sigmoid abruptness fraction}
    }
    make_transparent {
        params {material sigmoid abruptness start limit fraction t}
        types {material sel sigmoid sel abruptness float start float limit float t float fraction string}
        defaults {material Opaque sigmoid "t" abruptness 1.0 start 0.0 limit 1.0 t 3}
        color "pale turquoise"
        alwayson {material ""}
        abbr transpr
        unpack false
        secondary {sigmoid abruptness fraction}
    }
    overlay_text {
        params {origin mode alias sigmoid alpha numeric_range text textsize textcolor textbox decimal_points center t}
        types {t float origin string mode sel alias string sigmoid sel alpha string numeric_range string text string textsize float textcolor string textbox string decimal_points int center boolean}
        defaults {origin "0,0" aspect_ratio 1.0 mode "ud" sigmoid "t" textsize 1 textcolor "black" textbox f decimal_points 3 center f}
        color gold
        alwayson {origin ""}
        abbr txtovrl
        unpack_actions {add_overlay ""}
        params_assign {origin add_overlay mode add_overlay alias add_overlay sigmoid add_overlay alpha add_overlay numeric_range "add_overlay-dataframes" text add_overlay textsize add_overlay textcolor add_overlay textbox add_overlay decimal_points add_overlay center add_overlay t add_overlay}
        unpack true
        secondary {sigmoid decimal_points}
    }
    overlay_plot {
        params {origin relative_size aspect_ratio mode alias sigmoid alpha transparent_background dataframes datafile dataframes_from_file seaborn 2D center t}
        types {t float origin string relative_size string aspect_ratio float mode sel alias string sigmoid sel alpha string transparent_background boolean dataframes string datafile dfile dataframes_from_file string seaborn boolean 2D boolean center boolean}
        defaults {origin "0,0" relative_size 1.0 aspect_ratio 1.0 mode "ud" sigmoid "t" transparent_background t seaborn f center f}
        color gold
        alwayson {origin "" relative_size ""}
        abbr pltovrl
        unpack_actions {add_overlay ""}
        params_assign {origin add_overlay relative_size add_overlay aspect_ratio add_overlay mode add_overlay alias add_overlay sigmoid add_overlay alpha add_overlay transparent_background add_overlay dataframes add_overlay datafile add_overlay dataframes_from_file add_overlay seaborn add_overlay 2D add_overlay center add_overlay t add_overlay}
        unpack true
        secondary {sigmoid dataframes_from_file seaborn 2D}
    }
    overlay_scene {
        params {origin relative_size mode alias sigmoid alpha transparent_background scene center t}
        types {t float origin string relative_size string mode sel alias string sigmoid sel alpha string transparent_background boolean scene string center boolean}
        defaults {origin "0,0" relative_size 1.0 mode "u" sigmoid "t" transparent_background t center f t 0}
        color gold
        alwayson {origin "" relative_size ""}
        abbr scnovrl
        unpack_actions {add_overlay ""}
        params_assign {origin add_overlay relative_size add_overlay mode add_overlay alias add_overlay sigmoid add_overlay alpha add_overlay transparent_background add_overlay scene add_overlay center add_overlay t add_overlay}
        unpack true
        secondary {sigmoid}
    }
    overlay_image {
        params {origin relative_size mode alias sigmoid alpha transparent_background figure center t}
        types {t float origin string relative_size string mode sel alias string sigmoid sel alpha string transparent_background boolean figure string center boolean}
        defaults {origin "0,0" relative_size 1.0 mode "u" sigmoid "t" transparent_background t center f}
        color gold
        alwayson {origin "" relative_size ""}
        abbr imgovrl
        unpack_actions {add_overlay ""}
        params_assign {origin add_overlay relative_size add_overlay mode add_overlay alias add_overlay sigmoid add_overlay alpha add_overlay transparent_background add_overlay figure add_overlay center add_overlay t add_overlay}
        unpack true
        secondary {sigmoid}
    }
    remove_distance {
        params {alias all}
        types {alias string all boolean}
        defaults {all f}
        color black
        alwayson {}
        abbr rmdist
        unpack false
        secondary {}
    }
    remove_label {
        params {alias all}
        types {alias string all boolean}
        defaults {all f}
        color black
        alwayson {}
        abbr rmlabl
        unpack false
        secondary {}
    }
    restore_viewpoint {
        params {alias sigmoid abruptness fraction t}
        types {alias string sigmoid sel abruptness float t float fraction string}
        defaults {sigmoid "t" abruptness 1.0 fraction "0.0:1.0" t 3}
        color green
        alwayson {alias ""}
        abbr restvp
        unpack false
        secondary {sigmoid abruptness fraction}
    }
    rewind_align {
        params {frame molecules selection ignore t}
        types {frame string molecules string selection string ignore boolean t float}
        defaults {frame "0" selection "all" ignore 1 t 0}
        color "sky blue"
        alwayson {selection ""}
        abbr animate
        unpack_actions {animate "" fit_trajectory ""}
        params_assign {frame "animate-frames" ignore animate molecules animate molecules fit_trajectory selection fit_trajectory t animate t fit_trajectory}
        unpack true
        secondary {molecules ignore}
    }
    rotate {
        params {axis angle sigmoid abruptness fraction molecules t}
        types {axis string angle float sigmoid sel abruptness float t float fraction string molecules string}
        defaults {axis "y" angle 45 sigmoid "t" abruptness 1.0 t 3}
        color wheat
        alwayson {axis "" angle ""}
        abbr rotate
        unpack false
        secondary {sigmoid abruptness fraction}
    }
    save_viewpoint {
        params {alias}
        types {alias string}
        defaults {}
        color black
        alwayson {alias ""}
        abbr savevp
        unpack false
        secondary {}
    }
    show_figure {
        params {figure datafile dataframes dataframes_from_file t}
        types {t float figure string datafile dfile dataframes string dataframes_from_file string}
        defaults {dataframes "init_frame:final_frame" dataframes_from_file "filename.dat" t 3}
        color "green yellow"
        alwayson {}
        abbr shfig
        unpack false
        secondary {datafile dataframes dataframes_from_file}
    }
    show_grid {
        params {}
        types {}
        defaults {}
        color black
        alwayson {}
        abbr shgrd
        unpack false
        secondary {}
    }
    toggle_molecule {
        params {molecule_id top freeze active drawn}
        types {molecule_id int top boolean freeze boolean active boolean drawn boolean}
        defaults {molecule_id 0 top f freeze f active f drawn f}
        color black
        alwayson {}
        abbr togmol
        unpack false
        secondary {}
    }
    translate {
        params {vector normalize sigmoid abruptness fraction molecules t}
        types {vector string normalize boolean sigmoid sel abruptness float t float fraction string molecules string}
        defaults {vector 0.5,0 normalize f sigmoid "t" abruptness 1.0 t 3}
        color yellow2
        alwayson {vector ""}
        abbr transl
        unpack false
        secondary {normalize sigmoid abruptness fraction molecules}
    }
    zoom_in {
        params {scale sigmoid abruptness fraction t}
        types {scale float sigmoid sel abruptness float t float fraction string}
        defaults {scale 1.5 sigmoid "t" abruptness 1.0 t 3}
        color gray86
        alwayson {scale ""}
        abbr zmin
        unpack false
        secondary {sigmoid abruptness fraction}
    }
    zoom_out {
        params {scale sigmoid abruptness fraction t}
        types {scale float sigmoid sel abruptness float t float fraction string}
        defaults {scale 1.5 sigmoid "t" abruptness 1.0 t 3}
        color gray74
        alwayson {scale ""}
        abbr zmout
        unpack false
        secondary {sigmoid abruptness fraction}
    }
}

# TODO sanitize float:float etc consistently

set ::molywood::actions_mo {
    add_master_overlay {
        params {origin relative_size aspect_ratio mode alias sigmoid alpha transparent_background dataframes datafile dataframes_from_file seaborn 2D text textsize textcolor textbox decimal_points scene figure movie center start_time t}
        types {t float origin string relative_size string aspect_ratio float mode sel alias string sigmoid sel alpha string transparent_background boolean dataframes string datafile string dataframes_from_file string seaborn boolean 2D boolean text string textsize int textcolor string textbox boolean decimal_points int scene string figure string movie string center boolean start_time float}
        defaults {origin "0,0" relative_size 1.0 aspect_ratio 1.0 mode "u" sigmoid "t" transparent_background f seaborn f 2D f textsize 1 textcolor "black" textbox f decimal_points 3 center f start_time 0 t 3}
        color gold
        alwayson {}
        abbr addmovrl
        secondary {}
    }
}

set ::molywood::substitute_values {"create (u)" u 
                                   "remove (d)" d 
                                   "create&remove (ud)" ud 
                                   "modify (n)" n 
                                   "smooth (t)" t 
                                   "sharp (n)" n 
                                   "smooth&steady (sls)" sls
                                   NewCartoon newcartoon 
                                   Surf surf 
                                   QuickSurf quicksurf 
                                   Licorice licorice 
                                   VDW vdw 
                                   CPK cpk 
                                   DynamicBonds dynamicbonds 
                                   Tube tube 
                                   IsoSurface isosurface
                                   "" ""}

set ::molywood::tooltips {
    2D "If on, will use Seaborn's density plot to plot a 2D distribution"
    abruptness "How abrupt should the smooth/eased transition be (default it 1)"
    active "If 't', the specified molecule will be set as active, and hence movable/animateable etc. (and vice versa with 'f')"
    alias "A name given to this action in order to reference it later, e.g. to modify, restore or close. Can also refer to an existing VMD representation with '_refN', where N is the 0-based index"
    all "If 't', removes all labels instead of one-by-one"
    alpha "Transparency, either a float between 0 and 1 or a dynamic range, e.g. 0.0:0.5"
    angle "The magnitude of the rotation, in degrees"
    aspect_ratio "For overlays, this will define the X-to-Y ratio into which the overlay will be fit; large values (>1) elongate overlays horizontally"
    atom_index "0-based, index of the atom that will be labeled"
    audiofile "Path to the audio file that will be used"
    axis "Must be x (horizontal), y (vertical) or z (normal to screen). If combinations are needed, combine two rotations, or use viewpoints"
    center "If set, the 'origin' parameter will specify the center of the overlay"
    code "A Tcl code literal that will be inserted into the script"
    color "Can be named (red, green, ...), index-based according to VMD (0, 1, 2, ...) or RGB (three 0-255 comma-separated numbers)"
    contour "Adds a contour to the representation, using VMD's Outline/OutlineWidth material properties"
    cutoff "Maximum distance for DynamicBonds" ;# TODO can be a range?
    datafile "Path to file with data and directives for plotting overlays"
    dataframes "By default, dynamic plots assume 1:1 correspondence with trajectory frames; if not the case, specify a subset of frames with from:to corresponding to the dataset in 'datafile'"
    dataframes_from_file "By default, dynamic plots assume 1:1 correspondence with trajectory frames; you can specify a file with data frame numbers corresponding to the dataset in 'datafile'"
    decimal_points "Integer number of decimal points to show in the dynamic text field"
    drawn "If 't', the specified molecule will be visible (and vice versa with 'f')"
    fade_in "Fraction of the action's duration during which the new representation will gradually become opaque (default 0.25)"
    fade_out "Fraction of the action's duration during which the new representation will gradually become transparent (default 0.25)"
    figure "Path to the image that will be used as an overlay"
    "file" "Path to the file containing the Tcl code to be inserted"
    fraction "If specified as from:to (e.g. 0:0.5), will perform a fraction of the full action; this is useful for introducing asynchronous concurrent actions"
    frame "A single 0-based frame index to go to; use 'last' to specify the final frame"
    frames "Either a single 0-based frame index to go to, or a range (from:to) of frames that will be animated; use 'last' to specify the final frame"
    freeze "If 't', the specified molecule will be set as frozen (and vice versa with 'f')"
    from "Starting time (in seconds) for the audio to be inserted from the original file"
    ignore "Will skip counting in preview (purely technical)"
    inline_parameter "Will replace a '\[\]' in 'selection' with a dynamic numerical range over which linear interpolation will be performed"
    invert "If 't', changes the direction of the automatic alignment to axis"
    isovalue "For isodensity representation, sets the isovalue (single float) or the dynamic range of isovalues (from:to)"
    label "The text that will be used for labeling"
    label_color "Sets the color of label using VMD color naming (either integer-based ID or name)"
    length "Specifies the length of the audio to be extracted from the source file"
    limit "Will finish at this value of partial opacity or transparency (depends if make_opaque/transparent)"
    loop_command "A Tcl command with a pair of braces indicating where the iterator (defined by 'range' or 'loopover') will be inserted"
    loopover "Use with 'loop_command' to explicitly list values that will be inserted in the loop (as comma-separated list)"
    material "Any material name from VMD: opaque, diffuse, transparent, ..."
    mode "Has to be 'u' (up, creates an overlay), 'd' (down, removes an overlay), 'n' (edits overlay properties), or 'ud' (create and destroy in one action)"
    molecule_id "The 0-based molecule index of the molecule whose properties will be toggled"
    molecule_ref "The 0-based index of the molecule that is being used as a reference for alignment"
    molecules "Applies the action to selected molecules only; can be 'all', 'top', a 0-based index, or a comma-separated list of indices"
    movie "Path to a video file if a movie is used as an overlay"
    multiframe "Allows for drawing multiple frames either as from:to or dynamic range from0-from1:to0-to1; NOTE needs to be set to 'now' later for 'animate' to work properly"
    normalize "Recalculates the translation so that the distance from the center to the edge is always equal to 1 (otherwise depends on many factors)"
    numeric_range "If provided as a range, will fill the '[]' placeholder in the 'text' entry with a dynamically changing number in the given range"
    offset "A pair of X,Y values that will offset/move the label to avoid it overlaping with the underlying atoms"
    origin "Either a pair of X,Y floats for the origin (in window units), or dynamic range specified as X0:X1,Y0:Y1; specifies the location of the bottom left corner unless 'center' is set"
    range "If used with loop_command, can create an iterator with a dynamically changed variable for custom Tcl code; value will be inserted instead of a pair of curly braces (check Samples)"
    relative_size "For scenes, plots and figures (but not text), the overlay will be fit into a rectangle defined by this fraction of the whole window, so 1.0 means fit within the entire window"
    scale "Scaling factor, 1.0 does nothing; if you zoom_in by 1.5 and zoom_out by 1.5, you end up with the same view"
    scene "Name of the scene to be used as an overlay"
    seaborn "Whether to use seaborn (t) or plain matplotlib (f) for 2D plots"
    selection "The VMD-compatible selection to which the action will be applied"
    selection1 "The distance will be shown from the COM of this group"
    selection2 "The distance will be shown to the COM of this group"
    selection_ref "The VMD-compatible selection of the reference atoms for alignment. NOTE: needs to have the same number of atoms as 'selection'"
    sigmoid "Whether to make the transition soft (t), linear/abrupt (f) or 'eased in' (sls, for sigmoid-linear-sigmoid)"
    smooth "Will set a trajectory smoothing of this number of frames for all representations"
    start "Will start from this value of partial opacity or transparency (depends if make_opaque/transparent)"
    start_time "Starting time for master overlay in absolute movie time (check the diagram)"
    style "A VMD-compatible style name, can be any of the following: newcartoon/licorice/surf/quicksurf/vdw/cpk/tube/isosurface/dynamicbonds"
    t "Duration of the current action; if 0, it will be performed instantaneously"
    text "Text that will be displayed as the overlay; use a [] placeholder for dynamic/animated text"
    textbox "Specifies matplotlib parameters of the box around text, e.g. 'boxstyle:round4,ec:g' gives rounded edges and green edgecolor"
    textcolor "Color of the text, will be passed to Python's matplotlib"
    text_size "Relative size of the label"
    textsize "Relative size, 1.0 yields text of reasonable size"
    thickness "Relative thickness, 1.0 corresponds to VMD defaults; if representations directly occlude each other, specify a value slightly larger than 1"
    top "If 't', the specified molecule will be set as top (and vice versa with 'f')"
    transparent_background "Will remove white pixels from an overlay to avoid eclipsing the underlying image"
    vector "Two comma-separated components for X- and Y-translation; scale is rougly relative to the screen, i.e. a translation of 1.0 is quite large"
    volume "Relative volume for audio files, 1.0 preserves input volume"
    volume_offset "To use one set of cube files for isosurface, and cubes offset by this number for coloring the isosurface"
}

set ::molywood::tooltips_values {
    abruptness "Example values: 0.2, 1, 5 etc."
    alias "Example values: 'helix', 'my_rep1'. '_rep0', '_rep1' will refer to existing VMD representation nr 0, 1 etc."
    alpha "Example values: '0' for transparent, '0.0:0.5' to change from transparent to semi-transparent, '1:0.75' to add a bit of transparency"
    angle "Example values: 60, -360, 1080 etc."
    aspect_ratio "Example values: 0.5, 2.0 etc."
    atom_index "Example values: 0, 5, 190 etc."
    audiofile "Example values: '/home/me/Sound/recording.mp3', 'soundtrack.wav' etc."
    axis "Example values: 'x', 'y', or 'z'"
    code "Example values: 'display dof on', 'color change rgb 2 gray 0.35 0.16 0.16'"
    color "Example values: 'red', 'name', '8', '255,255,255' etc."
    contour "Example values: '1.0', '0.0', '1.0:0.2' etc. (0 means no contour, 1 means full contour)"
    cutoff "Example values: '3.5', '1.2' etc."
    datafile "Example values: '/home/my/Data/analysis/dist.dat', 'values.txt' etc."
    dataframes "Example values: '0:250' (e.g. animate+graph), 0:0.25 (e.g. text with a dynamic field) etc."
    dataframes_from_file "Example values: '/home/my/analysis/data_file.txt', 'local_distance.dat' etc."
    decimal_points "Example values: '1', '3' etc."
    fade_in "Example values: '0.0' (instantaneous), '0.25', '1.0'"
    fade_out "Example values: '0.0' (instantaneous), '0.25', '1.0'"
    figure "Example values: '/home/my/Pictures/logo.png', 'graph.svg' etc."
    "file" "Example values: '/home/my/Codes/snippet.tcl', 'mycode.tcl' etc."
    fraction "Example values: '0.0:1.0' (whole action), ':0.5' (1st half), '0.25:0.75' etc."
    frame "Example values: '0' (beginning), 'last' (end), '20', etc."
    frames "Example values: '0' (beginning), 'last' (end), '20', '0:150' etc."
    from "Example values: '0', '12.5' etc. (in seconds)"
    ignore "Will skip counting in preview (purely technical)"
    inline_parameter "Example values: '2' (just to fill placeholder with a static value), '1:100' (will replace placeholder with integers), '1.0:100.0' (will replace with floats)"
    isovalue "Example values: '0.001', '-0.1:0.1' etc. (in file's units)"
    label "Example values: 'CoM chain A', 'helix D glutamate'"
    label_color "Example values: 'red', '8', '255,255,255' etc."
    length "Example values: '5', '20' etc. (in seconds)"
    limit "Example values: '0.1', '1.0' etc."
    loop_command "Example values: 'display dof_focaldist \{\}' (should contain the curly bracket for placement of the variable from 'loopover'/'range')"
    loopover "Example values: '0.23,0.95,0.55,0.75', 'a,b,c,d' etc."
    material "Example values: 'opaque', 'diffuse', 'transparent'"
    mode "Example values: 'u', 'd', 'n', 'ud'"
    molecule_id "Example values: '0', '1', 'top' etc."
    molecule_ref "Example values: '0', '1', 'top' etc."
    molecules "Example values: 'all', 'top', '0,1', '0' etc."
    movie "Example values: '/home/my/Movies/molecular/movie.mp4', 'anim.gif' etc."
    multiframe "Example values: 'now', '0-20', '0-0:20' (following 'from0:from1-to0:to1' pattern) etc."
    numeric_range "Example values: '0-1', '0.0-0.2', '200-1000' etc."
    offset "Example values: '0.1,0.1', '-0.2,-0.1' etc."
    origin "Example values: '0,0' (static), '0.5,0:0.5' (dynamic in Y), 0:0.25,0.25:0.5 (both dynamic)"
    range "Example values: '0.2:1.2' etc."
    relative_size "Example values: '1.0' (static), '1.0:0.2' (dynamic)"
    scale "Example values: '1.5', '4.5' etc."
    scene "Example values: 'scene1', 'myoverlay' etc."
    selection "Example values: 'nucleic', 'resid 5 to 55', 'index []' (see 'inline parameter' for dynamic selections) etc."
    selection1 "Example values: 'nucleic', 'resid 5 to 55' etc."
    selection2 "Example values: 'nucleic', 'resid 5 to 55' etc."
    selection_ref "Example values: 'nucleic', 'resid 5 to 55' etc."
    sigmoid "Example values: 't', 'f', 'sls'"
    smooth "Example values: '1', '5', '15' etc."
    start "Example values: '0.1', '1.0' etc."
    start_time "Example values: '0', '12.5' etc. (in seconds)"
    style "Example values: 'newcartoon' ,'licorice', 'surf', 'quicksurf', 'vdw', 'cpk', 'tube', 'isosurface', 'dynamicbonds'"
    t "Example values: '0', '2', '5.5'"
    text "Example values: 'opening pathway', '[] nanoseconds' (for dynamical text), 'my $\\alpha$-helix' (LaTeX is allowed too)"
    textbox "Example values: 'boxstyle:roundtooth', 'boxstyle:round4,ec:g' (check matplotlib's bbox)"
    textcolor "Example values: 'C0', 'black', 'tomato' etc. (following matplotlib's namings)"
    text_size "Example values: '1.0', '3', '0.25' etc."
    textsize "Example values: '1.0', '3', '0.25' etc."
    thickness "Example values: '1.0', '2.5', '1.0:0.2' etc"
    vector "Example values: '0.2,-0.5', '2,2,0' (3rd value can be skipped as it's ignored anyway)"
    volume "Example values: '1.5', '0.7' etc."
    volume_offset "Example values: '25', '50' etc."
}


set ::molywood::templates {
    rotzoom "$ global name=my_movie\n$ scene1 resolution=750,750\n# scene1\nrotate axis=y angle=360 sigmoid=sls fraction=:0.5 t=3 \n{rotate axis=y angle=360 sigmoid=sls fraction=0.5:1.0 t=3 ;\nzoom_in scale=3.5 t=3 ;\ntranslate vector=0.4,0.4 normalize=t sigmoid=t t=3 } \nhighlight selection='resname LYS ARG' color=name mode=u material=Diffuse style=licorice thickness=1.5 alias=hl1 t=2 \n{do_nothing t=2 ;\nadd_overlay origin=0.05,0.9 mode=ud text='binding interface' textbox=boxstyle:round4 center=f } \nhighlight mode=d alias=hl1 t=2 \n{rotate axis=y angle=330 sigmoid=sls fraction=0:0.5 t=3 ;\nzoom_out scale=3.5 sigmoid=t t=3 ;\ntranslate vector=-0.4,-0.4 normalize=t sigmoid=t t=3 } \nrotate axis=y angle=330 sigmoid=sls fraction=0.5:1 t=3 \ndo_nothing t=2 \n"
    fade "$ global name=my_movie \n$ scene1 resolution=750,750 \n\n# scene1\nmake_transparent material=Opaque   \nhighlight selection='not protein and not water and not nucleic and noh' color=name mode=u material=Diffuse alpha=1.0 style=licorice cutoff=1.6 fade_in=0.2 fade_out=0.2 thickness=1.2 alias=background molecules=all t=0   \nhighlight selection=protein color=structure mode=u material=Diffuse alpha=1.0 style=newcartoon cutoff=1.6 fade_in=0.2 fade_out=0.2 thickness=1.2 alias=solute molecules=all t=0   \ncenter_view selection='protein or nucleic' molecules=all   \nzoom_out scale=25 sigmoid=t t=0   \nzoom_in scale=25 sigmoid=t t=0   \nhighlight selection='nucleic and noh' color=type mode=u material=Diffuse alpha=1.0 style=licorice cutoff=1.6 fade_in=0.2 fade_out=0.2 thickness=1.3 alias=nucleic molecules=all t=0   \ndo_nothing t=1   \nzoom_in scale=1.5 sigmoid=t fraction=0:0.67 t=2   \n\{zoom_in scale=1.5 sigmoid=t fraction=0.67:1 t=1;\nhighlight mode=d material=Opaque alpha=1.0 style=newcartoon alias=background molecules=all t=1\} \ndo_nothing t=1   \nanimate frames=0:last smooth=1 t=4   \nzoom_out scale=1.5 sigmoid=t t=3   \n\n\n"
    sidebyside "$ global name=my_movie \n$ layout columns=2\n$ scene1 resolution=750,750 position=0,0\n$ scene2 resolution=750,750 position=0,1\n# scene1\nzoom_in scale=1.5 t=2\nanimate frames=0:last t=2\nzoom_out scale=1.5 t=2\ndo_nothing t=7s\n# scene2\ndo_nothing t=7s\nzoom_in scale=1.5 t=2\nanimate frames=0:last t=2\nzoom_out scale=1.5 t=2\n"
    frameshooter "$ global name=my_movie \n$ main_scene resolution=900,600\n$ scene1 resolution=900,600\n$ scene2 resolution=900,600\n$ scene3 resolution=900,600\n\n# main_scene\ntranslate vector=0.5,0,0\ndo_nothing t=1s\n\{ animate t=2s frames=last:9;\n add_overlay scene=scene1 transparent_background=t mode=u\}\n\{ animate t=2s frames=8:0;\n add_overlay scene=scene2 transparent_background=t mode=u;\n add_overlay text=final origin=0.25,0.75 mode=u\}\n\{ animate t=2s frames=0:last;\n add_overlay scene=scene3 transparent_background=t mode=u;\n add_overlay text=intermediate origin=0.25,0.4 mode=u\}\n\{ do_nothing t=2s;\n add_overlay text=starting origin=0.25,0.05 mode=u\}\n\n# scene1\ntranslate vector=0.5,0,0\nanimate frames=last\n\{ zoom_out scale=2.5;\n translate vector=-2.5,1.2,0 t=1s\}\ndo_nothing t=7s\n\n# scene2  \ntranslate vector=0.5,0,0\nanimate frames=8\n\{ zoom_out scale=2.5;\n translate vector=-2.5,0.2,0 t=1s\}\ndo_nothing t=5s\n\n# scene3\ntranslate vector=0.5,0,0\nanimate frames=0\n\{ zoom_out scale=2.5;\n translate vector=-2.5,-0.8,0 t=1s\}\ndo_nothing t=3s\n\n"
}


set ::molywood::samples {
    animate1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nanimate  frames=0\nanimate  frames=0:17  t=2s\nanimate  frames=17:0  t=2s smooth=5\n"
    animate2 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nanimate  frames=0\nanimate  frames=0:17  t=1s\nanimate  frames=17:9  t=2s\nanimate  frames=9:17  t=0.5s\nanimate  frames=17:0  t=4s\n"
    label1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nadd_label     atom_index=77 label='Leu 11'\n\{highlight    selection='resid 11' t=3s color=type style=licorice;\n rotate       axis=y angle=60\} \nremove_label  all=t\n\nadd_label     atom_index=152 label='Lys 20' label_color=blue\n\{highlight    selection='resid 20' t=3s color=type style=licorice;\n rotate       axis=y angle=-60\}\n"
    label2 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nadd_label     atom_index=74 label='Leu 11' offset=0.1,0.05\n\{highlight    selection='resid 11' t=3s color=type style=licorice;\n rotate       axis=y angle=60\} \nremove_label  all=t\n\nadd_label     atom_index=148 label='Lys 20' offset=0.18,0.05 label_color=blue\n\{highlight    selection='resid 20' t=3s color=type style=licorice;\n rotate       axis=y angle=-60\}\n"
    audio1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\ntranslate   vector=-1.25,0,0\n\{rotate     axis=y angle=3600 t=10s sigmoid=f;\nadd_audio   audiofile=rick.mp3;\ntranslate   vector=2.6,0,0\}\ntranslate   vector=-1.35,0,0\nzoom_out    scale=40\nmake_transparent material=Diffuse\n\{zoom_in    scale=40 t=8s;\nhighlight   selection=all color=structure mode=u;\nadd_audio   audiofile=rick.mp3 from=127;\nrotate      axis=y angle=-7200 fraction=0.5:\}\ndo_nothing  t=2s\n"
    audio2 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\n\{rotate     axis=y angle=360 t=6s;\nadd_audio   audiofile=rainbow.mp3 from=4 length=8 fade_out=4\}\ntranslate   vector=0,4,0 t=2s fraction=:0.5\ntranslate   vector=0,-4,0\ntranslate   vector=0,4,0 t=2s fraction=0.5:\n do_nothing t=4s\}\n"
    basic1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nshow_figure  figure=start.png t=2s\nrotate       axis=y angle=30 t=4s\nrotate       axis=y angle=-30 t=4s\nshow_figure  figure=end.png t=2s\n"
    basic2 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nrotate       axis=y angle=60 t=1s\ninsert_tcl   code='color Display Background cyan'\nrotate       axis=y angle=-60 t=1s\n\n\{rotate      axis=y angle=60 t=1s;\ninsert_tcl   range=0.75:0.48 loop_command='color change rgb 10 0.250000 \{\} 0.750000'\}\n\nrotate       axis=y angle=-60 t=1s\n\n\{rotate      axis=y angle=60 t=1s;\ninsert_tcl   loopover=0.23,0.95,0.55,0.75 loop_command='color change rgb 10 0.250000 \{\} 0.750000'\}\n\ndo_nothing t=1s\n\n"
    centering1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\ncenter_view  selection='resid 1'\nhighlight    selection='resid 1' t=1s style=licorice mode=u alias=r1 color=type\nzoom_in      scale=3.0 t=1s \n\{highlight   t=1s mode=d alias=r1;\n zoom_out    scale=3.0\}\n     \ncenter_view  selection='resid 132'\nhighlight    selection='resid 132' t=1s style=licorice mode=u alias=r132 color=element\nzoom_in      scale=3.0 t=1s \n\{highlight   t=1s mode=d alias=r132;\n zoom_out    scale=3.0\}\ndo_nothing   t=1s\n\ncenter_view  selection='resid 206'\nhighlight    selection='resid 206' t=1s style=licorice mode=u alias=r206 color=name\nzoom_in      scale=3.0 t=1s \n\{highlight   t=1s mode=d alias=r206;\n zoom_out    scale=3.0\}\ndo_nothing   t=1s\n"
    centering2 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\ncenter_view       selection='resid 105 to 235 or resid 265 to 275'\nhighlight         selection='resid 105 to 235 or resid 265 to 275' material=Diffuse color=structure mode=u alias=h1\nmake_transparent  material=Diffuse limit=0.4 t=1s\nrotate            axis=x angle=90 t=2s\nmake_opaque       material=Diffuse start=0.4 limit=1 t=1s\nhighlight         alias=h1 mode=d\n\ncenter_view       selection='not (resid 105 to 235 or resid 265 to 275)'\nhighlight         selection='not (resid 105 to 235 or resid 265 to 275)' material=diffuse color=structure mode=u alias=h1\nmake_transparent  material=Diffuse limit=0.4 t=1s\nrotate            axis=x angle=90 t=2s\nmake_opaque       material=Diffuse start=0.4 limit=1 t=1s\n"
    concurrency1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nrotate    angle=1080 axis=y sigmoid=sls t=2s fraction=:0.25\n\{rotate   angle=1080 axis=y sigmoid=sls t=2s fraction=0.25:0.5;\n zoom_in  scale=3\}\n\{rotate   angle=1080 axis=y sigmoid=sls t=2s fraction=0.5:0.75;\n zoom_out scale=3\}\nrotate    angle=1080 axis=y sigmoid=sls t=2s fraction=0.75:\n"
    concurrency2 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nhighlight   selection='resid 15 to 31' color=white mode=u alias=highl t=2s\nrotate      axis=y angle=-90 t=2s\n\{highlight  mode=d alias=highl t=2s;\n rotate     axis=y angle=90\}\n"
    distance1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nadd_distance    selection1='resid 41' selection2='resid 165' bead=t\nanimate         frames=0:17 t=2s\nanimate         frames=17:0 t=2s\n"
    distance2 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nadd_distance    selection1='resid 41' selection2='resid 165'\nadd_distance    selection1='resid 151' selection2='resid 255' text_size=2 alias=pair\nanimate         frames=0:17 t=2s\nadd_distance    selection1='resid 14' selection2='resid 217' label_color=red\nremove_distance alias=pair\nanimate         frames=17:9 t=1s\nremove_distance all=t\nanimate         frames=8:0 t=1s\n"
    fitting1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nanimate         frames=0\nfit_trajectory  selection='not (resid 105 to 235 or resid 265 to 275)'\nanimate         frames=0:17 t=2s\nfit_trajectory  selection='resid 105 to 235 or resid 265 to 275'\nanimate         frames=17:0 t=2s\ndo_nothing      t=1s\n"
    fitting2 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nanimate         frames=0\nhighlight       selection='resid 15 to 31' style=newcartoon color=red mode=u t=1s alias=helix\nfit_trajectory  selection='resid 15 to 31' axis=z t=2s\nfit_trajectory  selection='resid 15 to 31' axis=x t=2s\nfit_trajectory  selection='resid 15 to 31' axis=y t=2s\nhighlight       mode=d t=1s alias=helix\n"
    highlight1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nhighlight  selection='resid 15 to 31' style=newcartoon color=green t=2s\nhighlight  selection='resid 15 to 31' style=licorice color=type t=2s\nhighlight  selection='resid 15 to 31' style=licorice color=type-C:gray t=2s\nhighlight  selection='resid 15 to 31' style=vdw color=name t=2s\nhighlight  selection='resid 15 to 31' style=vdw color=name-N:orange-O:green-C:pink t=2s\nhighlight  selection='resid 15 to 31' style=quicksurf color=white t=2s\n"
    highlight2 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\ncenter_view  selection='resid 23'\n\{highlight   selection='resid 15 to 31' style=newcartoon color=green mode=u alias=h1 t=1.5s;\n zoom_in     scale=3 fraction=:0.33\}\n\{highlight   selection='resid 18 to 28' style=newcartoon color=red mode=u alias=h2 t=1.5s thickness=1.05;\n zoom_in     scale=3 fraction=0.33:0.67\}\n\{highlight   selection='resid 21 to 25' style=newcartoon color=yellow mode=u alias=h3 t=1.5s thickness=1.1;\n zoom_in     scale=3 fraction=0.67:\}\n\{highlight   mode=d alias=h3 t=1.5s;\n zoom_out    scale=3 fraction=:0.33\}\n\{highlight   mode=d alias=h2 t=1.5s;\n zoom_out    scale=3 fraction=0.33:0.67\}\n\{highlight   mode=d alias=h1 t=1.5s;\n zoom_out    scale=3 fraction=0.67:\}\n"
    highlight3 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nhighlight    style=isosurface color=orange mode=u alias=iso isovalue=0.045:0.03 t=3s\nhighlight    style=isosurface color=white mode=u alias=iso2 isovalue=0.017 alpha=0.3 t=3s\nhighlight    alias=iso isovalue=0.03:0.038 t=1s\nrotate       axis=y angle=180 t=3s\nhighlight    alias=iso mode=d t=2s fade_out=1.0\nhighlight    alias=iso2 mode=d t=2s\n"
    highlight4 "\n$ scene1 visualization=density.vmd\n\n# scene1\n\n\nhighlight    style=isosurface color=white mode=u alias=iso isovalue=0.045:0.02 t=3s\n\{highlight   alias=iso alpha=1:0.5 t=4s mode=n fade_in=1;\n highlight   selection=all color=structure mode=u alias=helix\}\n\{highlight   alias=helix thickness=1:1.5 t=3s mode=n;\n rotate      axis=y angle=180 fraction=:0.5\}\n\{highlight   alias=iso isovalue=0.02:0.05 alpha=0.5 mode=d t=3s;\n rotate      axis=y angle=180 fraction=0.5:\}\nhighlight    alias=helix thickness=1.5:0 fade_in=1 mode=n t=3s\n"
    highlight5 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nanimate          frames=0\nfit_trajectory   selection='resid 20 to 30'\nhighlight        selection=protein t=1s color=structure mode=u alias=mf style=newcartoon material=diffuse\n\n\nmake_transparent material=diffuse\nhighlight        multiframe=0:0-17 t=1s mode=n alias=mf\nfit_trajectory   selection='resid 220 to 230' t=1s\nhighlight        multiframe=0-17:17 t=1s mode=n alias=mf\ndo_nothing       t=1s\n\n\nanimate          frames=17\n\{highlight        multiframe=now alias=mf mode=n;\nanimate          frames=17:0 t=1s\}\ndo_nothing t=1s\n"
    highlight6 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nhighlight mode=n style=newcartoon thickness=1.0:0.1 alias=_rep0 t=3\nhighlight mode=n alpha=1.0:0.25 style=newcartoon thickness=0.1:2.0 alias=_rep0 t=3"
    highlight7 "\n$ scene1 visualization=INPUTPATH \n# scene1\nmake_transparent material=Diffuse sigmoid=t start=0.0 limit=1.0 t=0   \nhighlight selection='resid < \[\]' color=structure mode=u material=Diffuse alpha=1.0 style=newcartoon alias=dynamic inline_parameter=1:350 t=3   \nhighlight selection='y > \[\]' color=name mode=u material=Diffuse alpha=1.0 style=licorice alias=dynamic2 inline_parameter=50:-70 t=3   \nhighlight mode=n alias=dynamic2 inline_parameter=-70:50 t=3   \nhighlight mode=n alias=dynamic inline_parameter=350:1 t=3   \n"
    scenes1 "\n$ layout columns=3 rows=3\n$ scene1 pdb_code=1w0t resolution=400,400 position=0,0\n$ scene2 pdb_code=5zfz resolution=400,400 position=0,1\n$ scene3 pdb_code=1jgg resolution=400,400 position=0,2\n$ scene4 pdb_code=3lnq resolution=400,400 position=1,0\n$ scene5 pdb_code=1ig7 resolution=400,400 position=1,1\n$ scene6 pdb_code=1b72 resolution=400,400 position=1,2\n$ scene7 pdb_code=1yrn resolution=400,400 position=2,0\n$ scene8 pdb_code=1puf resolution=400,400 position=2,1\n$ scene9 pdb_code=1w0u resolution=400,400 position=2,2\n\n\n# scene1,scene2,scene3,scene4,scene5,scene6,scene7,scene8,scene9\n\nzoom_in scale=1.4\nfit_trajectory axis=y selection='nucleic and not backbone'\nrotate  axis=y angle=720 t=10s sigmoid=sls\n"
    scenes2 "\n$ layout columns=3 rows=3\n$ scene1 pdb_code=1w0t resolution=400,400 position=0,0\n$ scene2 pdb_code=5zfz resolution=400,400 position=0,1\n$ scene3 pdb_code=1jgg resolution=400,400 position=0,2\n$ scene4 pdb_code=3lnq resolution=400,400 position=1,0\n$ scene5 pdb_code=1ig7 resolution=400,400 position=1,1\n$ scene6 pdb_code=1b72 resolution=400,400 position=1,2\n$ scene7 pdb_code=1yrn resolution=400,400 position=2,0\n$ scene8 pdb_code=1puf resolution=400,400 position=2,1\n$ scene9 pdb_code=1w0u resolution=400,400 position=2,2\n\n\n# scene1,scene2,scene3,scene4,scene5,scene6,scene7,scene8,scene9\n\nzoom_in            scale=1.4\nfit_trajectory     axis=y selection='nucleic and not backbone'\nmake_transparent   material=Opaque\nhighlight          selection='nucleic and noh' material=Diffuse style=licorice color=type mode=u\nhighlight          selection=protein material=Diffuse style=quicksurf color=white mode=u\nrotate  axis=y angle=720 t=10s sigmoid=sls\n"
    scenes3 "\n$ scene1 pdb_code=1w0t,1w0u\n\n# scene1\n\n\nrotate  axis=x angle=90\ntranslate vector=0.4,0,0\ntoggle_molecule molecule_id=1 freeze=t\ntranslate vector=-2.5,-1.8,0\ntranslate vector=5,0,0 t=2s fraction=0:0.5\ntoggle_molecule molecule_id=1 freeze=f\ntoggle_molecule molecule_id=0 freeze=t\ntranslate vector=5,0,0 t=2s fraction=0.5:1\n\n"
    scenes4 "\n$ scene1 pdb_code=1w0t,1w0u\n\n# scene1\n\n\nrotate           axis=x angle=90\ntranslate        vector=0.4,0,0 t=1s\ntoggle_molecule  molecule_id=1 freeze=t\ntranslate        vector=-0.3,-1.8,0 t=1s\nfit_trajectory   selection=nucleic axis=z t=1s molecules=0\nfit_trajectory   selection=nucleic axis=z t=1s molecules=1\ntoggle_molecule  molecule_id=1 freeze=f\n\ntoggle_molecule  molecule_id=0 freeze=t\nrotate           axis=y angle=-165 t=1s\ntoggle_molecule  molecule_id=0 freeze=f\n\ntoggle_molecule  molecule_id=0 top=t\nhighlight        selection='resid 418 to 430' style=licorice color=type t=4s\ntoggle_molecule  molecule_id=1 top=t\nhighlight        selection='resid 484 to 500' style=licorice color=type t=4s\n"
    scenes5 "\n$ scene1 pdb_code=2lu1,6ckv\n\n\n# scene1\nzoom_out scale=1.2 t=1s\n\{translate molecules=0 vector=-0.75,0,0 t=1s;\ntranslate molecules=1 vector=0.6,0,0\}\nanimate molecules=0 frames=0:19 t=2s\nanimate molecules=1 frames=0:19 t=2s\n\ncenter_view selection=all\nrotate angle=360 axis=y fraction=0:0.5 t=1s\nrotate angle=360 axis=y fraction=0.5:1 t=1s molecules=0\nrotate angle=360 axis=y fraction=0.5:1 t=1s molecules=1\n\n\{rotate angle=-180 axis=y t=2s molecules=0;\nrotate angle=180 axis=x t=2s molecules=1\}\n"
    overlay10 "\n$ layout columns=3 rows=3\n$ master_overlay text='to make movies of' textbox=boxstyle:round4,ec:g textsize=1.5 start_time=4 t=4s center=t origin=0,-0.05\n$ scene1 pdb_code=1w0t resolution=400,400 position=0,0\n$ scene2 pdb_code=5zfz resolution=400,400 position=0,1\n$ scene3 pdb_code=1jgg resolution=400,400 position=0,2\n$ scene4 pdb_code=3lnq resolution=400,400 position=1,0\n$ scene5 pdb_code=1ig7 resolution=400,400 position=1,1\n$ scene6 pdb_code=1b72 resolution=400,400 position=1,2\n$ scene7 pdb_code=1yrn resolution=400,400 position=2,0\n$ scene8 pdb_code=1puf resolution=400,400 position=2,1\n$ scene9 pdb_code=1w0u resolution=400,400 position=2,2\n\n\n# scene1,scene2,scene3,scene4,scene5,scene6,scene7,scene8,scene9\n\nzoom_in            scale=1.4\nfit_trajectory     axis=y selection='nucleic and not backbone'\nmake_transparent   material=Opaque\nhighlight          selection='nucleic and noh' material=Diffuse style=licorice color=type mode=u\nhighlight          selection=protein material=Diffuse style=quicksurf color=white mode=u\nrotate  axis=y angle=720 t=10s sigmoid=sls\n\n"
    overlay1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\n\{animate     frames=0:17 t=3s;\n add_overlay datafile=pca.dat relative_size=0.5 origin=0.5,0.5 aspect_ratio=1\}\n\{animate     frames=17:0 t=3s;\n add_overlay datafile=pca.dat relative_size=0.5 origin=0.5,0.5 aspect_ratio=1 transparent_background=t\}\n"
    overlay2 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\n\{animate     frames=0:4 t=1.5s;\n add_overlay datafile=pca.dat relative_size=0.4\}\n\{animate     frames=12:17 t=1.5s;\n add_overlay datafile=pca.dat relative_size=0.4\}\n\{animate     frames=11:5 t=1.5s;\n add_overlay datafile=pca.dat relative_size=0.4\}\n"
    overlay3 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\n\{animate     frames=0:17 t=3s;\n add_overlay datafile=pca2.dat relative_size=0.4 transparent_background=t\}\n\{animate     frames=17:0 t=3s;\n add_overlay datafile=pca2.dat relative_size=0.4 transparent_background=t\}\n"
    overlay4 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\n\{animate     frames=0:17 t=3s;\n add_overlay datafile=pca3.dat relative_size=0.4 origin=0.6,0.6 aspect_ratio=1 2D=t\}\n\{animate     frames=17:0 t=3s;\n add_overlay datafile=pca4.dat relative_size=0.4 origin=0.0,0.0 aspect_ratio=1 2D=t\}\n"
    overlay5 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\n\{animate     frames=0:17 t=3s;\n add_overlay text='Forward transition' textsize=2 textcolor=orange origin=0.1,0.86\}\n\{animate     frames=17:0 t=3s;\n add_overlay text='Backward transition' textsize=0.5 origin=0.1,0.1\}\n"
    overlay6 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\n\{animate     frames=0:17 t=3s;\n add_overlay text='opening: \[\]' origin=0.6,0.8 dataframes=1:0\}\n\{animate     frames=17:0 t=3s;\n add_overlay text='closing: \[\]' origin=0.1,0.1 dataframes=1:0 decimal_points=1\}\n\{animate     frames=0:17 t=3s;\n add_overlay text='time: \[10\] ns' origin=0.6,0.8 decimal_points=0\}\n"
    overlay7 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nhighlight         selection=sheet color=structure material=diffuse mode=u alias=bsheets\n\{make_transparent material=diffuse t=2s;\n add_overlay      text='$\beta$ sheets' origin=0.6,0.8 alias=sheets mode=u\}\n\{make_opaque      material=diffuse t=2s;\n add_overlay      alias=sheets mode=d\}\nhighlight         mode=d alias=bsheets\n\nhighlight         selection=helix color=structure material=diffuse mode=u alias=helix\n\{make_transparent material=diffuse t=2s limit=0.25;\n add_overlay      text='$\{\rm \alpha\}$ helices' origin=0.1,0.1 mode=u\}\nmake_opaque       material=diffuse t=2s start=0.25\n"
    overlay8 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\n\{rotate      axis=y angle=60 t=4s;\n add_overlay figure=logo.png relative_size=0.02:0.3 origin=0:0.7,0:0.7 transparent_background=t\}\n\{rotate      axis=y angle=-60 t=4s;\n add_overlay movie=quent.mp4 relative_size=0.4 origin=0.05,0.05\}\n"
    overlay9 "\n$ main_scene visualization=INPUTPATH resolution=1500,1000\n$ scene1 visualization=INPUTPATH resolution=1500,1000\n$ scene2 visualization=INPUTPATH resolution=1500,1000\n\n\n# main_scene\ntranslate     vector=0.5,0,0\ndo_nothing    t=1s\n\{animate      t=2s frames=17:0;\n add_overlay  scene=scene1 transparent_background=t mode=u\}\n\{do_nothing   t=1s;\n add_overlay  text=closed origin=0.27,0.75 mode=u\}\n\{animate      t=2s frames=0:17;\n add_overlay  scene=scene2 transparent_background=t mode=u\}\n\{do_nothing   t=2s;\n add_overlay  text=open origin=0.32,0.22 mode=u\}\n\n# scene1\ntranslate     vector=0.5,0,0\nanimate       frames=17\n\{zoom_out     scale=2;\n translate    vector=-1.3,0.4,0 t=1s\}\ndo_nothing    t=6s\n\n# scene2\ntranslate     vector=0.5,0,0\nanimate       frames=0\n\{zoom_out     scale=2;\n translate    vector=-1.25,-0.35,0 t=1s\}\ndo_nothing    t=3s\n"
    overlay11 "\n$ layout columns=3 rows=3\n$ master_overlay text='to make movies of' textbox=boxstyle:round4,ec:g textsize=1.5 start_time=4 t=4s center=t origin=0,-0.05\n$ scene1 pdb_code=1w0t resolution=400,400 position=0,0\n$ scene2 pdb_code=5zfz resolution=400,400 position=0,1\n$ scene3 pdb_code=1jgg resolution=400,400 position=0,2\n$ scene4 pdb_code=3lnq resolution=400,400 position=1,0\n$ scene5 pdb_code=1ig7 resolution=400,400 position=1,1\n$ scene6 pdb_code=1b72 resolution=400,400 position=1,2\n$ scene7 pdb_code=1yrn resolution=400,400 position=2,0\n$ scene8 pdb_code=1puf resolution=400,400 position=2,1\n$ scene9 pdb_code=1w0u resolution=400,400 position=2,2\n\n\n# scene1,scene2,scene3,scene4,scene5,scene6,scene7,scene8,scene9\n\nzoom_in            scale=1.4\nfit_trajectory     axis=y selection='nucleic and not backbone'\nmake_transparent   material=Opaque\nhighlight          selection='nucleic and noh' material=Diffuse style=licorice color=type mode=u\nhighlight          selection=protein material=Diffuse style=quicksurf color=white mode=u\nrotate  axis=y angle=720 t=10s sigmoid=sls\n"
    overlay12 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\n\{animate     frames=0:17 t=3s;\n add_overlay text='Forward transition' textsize=2 textcolor=orange origin=0,0 center=t textbox=t\}\n\{animate     frames=17:0 t=3s;\n add_overlay text='Backward transition' textsize=0.5 origin=-0.3,-0.3 center=t textbox=style:sawtooth,ec:C0\}\n\{animate     frames=0:17 t=3s;\n add_overlay text=Forward origin=-0.2,-0.2 center=t textbox=style:rarrow angle=0:-90\}\n\{animate     frames=17:0 t=3s;\n add_overlay text=Backward origin=0.35:0.1,0.1:0.35 angle=0:-40 center=t textbox=style:larrow,fc:C1,alpha:0.5\}\n\n"
    render1 "\n$ scene1 visualization=INPUTPATH \n$ layout rows=1 columns=2\n$ scene1 visualization=INPUTPATH resolution=750,1000 position=0,0\n$ scene2 visualization=INPUTPATH resolution=750,1000 ambient_occlusion=t position=0,1\n\n\n# scene1, scene2\nrotate  axis=y angle=360 t=3s\n\n"
    render2 " draft=t\n$ layout rows=1 columns=2\n$ scene1 visualization=INPUTPATH resolution=750,1000 position=0,0\n$ scene2 visualization=INPUTPATH resolution=750,1000 position=0,1 draft=n\n\n# scene1, scene2\n\n\nrotate            axis=y angle=360 t=3s\nmake_transparent  t=2s material=diffuse limit=0.2\ndo_nothing        t=1s\n"
    rotation1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nrotate     axis=x angle=360 t=3s sigmoid=sls\nrotate     axis=y angle=360 t=3s sigmoid=t\nrotate     axis=z angle=360 t=3s sigmoid=f\ndo_nothing t=1s\n"
    rotation2 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\n\{rotate     axis=x angle=130 t=3s sigmoid=sls;\n rotate     axis=z angle=80 sigmoid=sls\}\n\{rotate     axis=x angle=-130 t=3s sigmoid=f;\n rotate     axis=z angle=-80 sigmoid=f\}\ndo_nothing t=1s\n"
    rotation3 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nrotate     axis=y angle=180 t=2s abruptness=3\nrotate     axis=y angle=-180 t=2s abruptness=0.8\ndo_nothing t=1s\n"
    rotation4 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\ndo_nothing t=1\nsave_viewpoint alias=initial\n\{rotate axis=x angle=35 sigmoid=t;\nrotate axis=y angle=190 sigmoid=t;\ntranslate vector=0.4,0.2 normalize=f sigmoid=t t=3\}\n\{zoom_out scale=2 sigmoid=t;\nrotate axis=z angle=90 sigmoid=t t=3\}\nrestore_viewpoint alias=initial sigmoid=t fraction=0.0:1.0 t=3"
    translation1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nzoom_in    scale=3\ntranslate  vector=-0.75,0.75,0\ndo_nothing t=0.5s\ntranslate  vector=0,0.75,0 t=1s\ndo_nothing t=0.5s\ntranslate  vector=0.75,-0.75,0 t=1s\ndo_nothing t=0.5s\ntranslate  vector=0,-1.5,0 t=1s\ndo_nothing t=0.5s\ntranslate  vector=1,-0.25,0 t=1s\ndo_nothing t=0.5s\n"
    translation2 "\n$ scene1 visualization=INPUTPATH \n$ scene2 visualization=INPUTPATH after=scene1\n\n\n# scene1\nanimate    frames=0\ndo_nothing t=1s\ntranslate  vector=-3,0,0 t=1s fraction=:0.5\n\n\n# scene2\nanimate    frames=17\ntranslate  vector=1.5,0,0\ntranslate  vector=-3,0,0 t=1s fraction=0.5:\ndo_nothing t=2s\n"
    transparency1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nhighlight         selection=sheet color=structure material=diffuse mode=u alias=bsheets\nmake_transparent  material=diffuse t=2s\nmake_opaque       material=diffuse t=2s\nhighlight         mode=d alias=bsheets\nhighlight         selection=helix color=structure material=diffuse mode=u alias=helix\nmake_transparent  material=diffuse t=2s limit=0.25\nmake_opaque       material=diffuse t=2s start=0.25\n"
    zoom1 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\nzoom_in    scale=4 t=2s sigmoid=t\nzoom_out   scale=4 t=2s sigmoid=f\ndo_nothing t=1s\n"
    zoom2 "\n$ scene1 visualization=INPUTPATH \n# scene1\n\n\n\{rotate    t=2s axis=y angle=180;\n zoom_in   scale=3\}\n\{rotate    t=2s axis=y angle=-180;\n zoom_out  scale=3\}\ndo_nothing t=1s\n"
    scenes6 {

        $ scene1 pdb_code=1w0t,1w0u
        \# scene1
        do_nothing t=1s
        rotate axis=x t=2s angle=90
        highlight molecules=1 selection="residue 111 to 115" color=1 style=vdw mode=u material=diffuse
        {fit_trajectory molecules=0 selection_ref="residue 111 to 115 and name C1' P" t=2s molecule_ref=1 selection="residue 105 to 109 and name C1' P";
        highlight molecules=0 selection="residue 105 to 109" color=0 style=vdw material=diffuse}
        {fit_trajectory molecules=0 selection_ref="residue 111 to 115 and name C1' P" t=2s molecule_ref=1 selection="residue 107 to 111 and name C1' P";
        highlight molecules=0 selection="residue 107 to 111" color=0 style=vdw material=diffuse}
        {fit_trajectory molecules=0 selection_ref="residue 111 to 115 and name C1' P" t=2s molecule_ref=1 selection="residue 109 to 113 and name C1' P";
        highlight molecules=0 selection="residue 109 to 113" color=0 style=vdw material=diffuse}
        {fit_trajectory molecules=0 selection_ref="residue 111 to 115 and name C1' P" t=2s molecule_ref=1 selection="residue 111 to 115 and name C1' P";
        highlight molecules=0 selection="residue 111 to 115" color=0 style=vdw material=diffuse}
        {fit_trajectory molecules=0 selection_ref="residue 111 to 115 and name C1' P" t=2s molecule_ref=1 selection="residue 113 to 117 and name C1' P";
        highlight molecules=0 selection="residue 113 to 117" color=0 style=vdw material=diffuse}
        do_nothing t=2s

    }
}

