#!/bin/sh

mkdir -p Exercise2.output
cd Exercise2.output

#Loop over lambda values
for l in 80 240 960
do
  filename=TLS-Dynamics_300K_lambda${l}
  cat > $filename.prm << ENDINPUT
OutputFile=$filename.out
NumStates=2
HierarchyTruncation=10
Temperature=300
Hamiltonian:
12100,500
500,12000
InitialDensityMatrix:
1.0,0.0
0.0,0.0
gamma:
10,10
lambda:
$l,$l
Timestep=0.0001
Time=0.5
ENDINPUT
  phi $filename.prm rk4 > $filename.log
  sed -e '/^\#/d' -e 's/(//g' -e 's/)//g ' -e 's/,/ /g' $filename.out | awk ' { print $1" "$2 } ' > ${filename}_00.out
done

gnuplot << ENDINPUT
set term post enhanced eps solid color lw 6.0 "Helvetica" 24
set out "Exercise2.output.eps"

set xrange [0:0.5] 
set yrange [0:1]

set key top right

set border 31 lw 0.4
set xlabel "t (ps)"
set ylabel "{/Symbol-Oblique r}_{00}(t)"

p "./TLS-Dynamics_300K_lambda80_00.out"  w l lc rgb "red" lw 1.0 ti "{/Symbol-Oblique l}=80 cm^{-1}",\
  "./TLS-Dynamics_300K_lambda240_00.out" w l lc rgb "green" lw 1.0 ti "{/Symbol-Oblique l}=240 cm^{-1}",\
  "./TLS-Dynamics_300K_lambda960_00.out" w l lc rgb "royalblue" lw 1.0 ti "{/Symbol-Oblique l}=960 cm^{-1}"

ENDINPUT
