#!/bin/sh

mkdir -p Exercise1.output
cd Exercise1.output

outputname=Exercise1.output.dat
echo "#L NumMatrices" > $outputname
for K in 0 1 2 3 4 5 6 
do
  echo "#K=$K" >> $outputname
  for L in 1 2 3 4 5 6
  do
    filename=TLS-NumMatrices_L${L}K${K}
    cat > $filename.prm << ENDINPUT
NumStates=2
HierarchyTruncation=$L
MatsubaraTerms=$K
ENDINPUT
    NumMatrices=`phi $filename.prm print | grep "Total: " | awk ' { print $2 } '`
    echo "$L $NumMatrices" >> $outputname
  done
  echo "" >> $outputname
  echo "" >> $outputname
done

gnuplot  << ENDINPUT
set term post enhanced eps solid color lw 6.0 "Helvetica" 24
set out "Exercise1.output.eps"

set xrange [1:6] 
set logscale y

set key top left title "Matsubara terms"

set border 31 lw 0.4
set xlabel "Hierarchy truncation"
set ylabel "Number of matrices in hierarchy"

p "$outputname" i 0 w l ti "1",\
  "$outputname" i 1 w l ti "2",\
  "$outputname" i 2 w l ti "3",\
  "$outputname" i 3 w l ti "4",\
  "$outputname" i 4 w l ti "5"
ENDINPUT

