// read DCD file frames

#include <stdio.h>
#include <stdlib.h>

#define FRAME_OFFSET 8
#define NOCHANGE 0x54
#define NEEDCHANGE 0x54000000
#define SWAP_LONG(A) A=((A>>24)&0xff)|((A>>8)&0xff00)|((A<<8)&0xff0000)|((A<<24)&0xff000000)

void main(int argc, char *argv[])
{
  FILE *in;
  long label, frames;

  in=fopen(argv[1],"r");
  if (in==NULL) { printf("%s is not a valid file name.\n", argv[1]); exit(0); }

  fread(&label,4,1,in);
  fseek(in,FRAME_OFFSET-4,SEEK_CUR);
  fread(&frames,4,1,in);
  if (label==NOCHANGE) { printf("%s contains %d frames.\n", argv[1], frames); }
  else if (label==NEEDCHANGE) { SWAP_LONG(frames); printf("%s contains %d frames.\n", argv[1], frames); }
  else { printf("%s is not a valid DCD file\n", argv[1]);}
  
  fclose(in);
 
}
