/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2003 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: parm7plugin.C,v $
 *      $Author: johns $       $Locker:  $             $State: Exp $
 *      $Revision: 1.15 $       $Date: 2003/06/12 19:39:23 $
 *
 ***************************************************************************/

#include <string.h>
#include "ReadPARM7.h"
#include "molfile_plugin.h"

typedef struct {
  ReadPARM *rp;
  FILE *parm;
  int natoms;
  int *from, *to;
} parmdata;

static void *open_parm7_read(const char *filename, const char *,int *natoms) {
  FILE *parm;
  ReadPARM *rp = new ReadPARM;
  if(!(parm = rp->open_parm7_file(filename))) {
    fprintf(stderr, "Cannot open parm file '%s'\n", filename);
    delete rp;
    return NULL;
  }
  
  if (rp->readparm(parm) != 0) {
    delete rp;
    // XXX should we call close_parm7_file???
    return NULL; 
  }
  *natoms = rp->get_parm7_natoms();
  parmdata *p = new parmdata;
  memset(p, 0, sizeof(parmdata));
  p->rp = rp;
  p->parm = parm;
  p->natoms =rp->get_parm7_natoms();
  return p;
}

static int read_parm7_structure(void *mydata, int *optflags, molfile_atom_t *atoms) {
  parmdata *p = (parmdata *)mydata;
  ReadPARM *rp = p->rp;
  rp->get_parm7_nbonds(); // XXX unused; but maybe there are side effects?
  rp->get_parm7_boxInfo(); // XXX unused, but maybe there are side effects?
  int i;

  // XXX not sure if we can really trust the Radii yet, perhaps add later.
  // *optflags = MOLFILE_CHARGE | MOLFILE_MASS | MOLFILE_RADIUS;
  *optflags = MOLFILE_CHARGE | MOLFILE_MASS;
 
  molfile_atom_t *atom;
  for (i=0; i<p->natoms; i++) {
    atom=atoms+i;
    // XXX Why isn't there a return code for error on read????
    rp->get_parm7_atom(i, atom->name, atom->type, atom->resname, atom->segid, &atom->resid, &atom->charge, &atom->mass, &atom->radius);
    atom->chain[0] = '\0';
  }

  return MOLFILE_SUCCESS;
}


static int read_parm7_bonds(void *v, int *nbonds, int **fromptr, int **toptr){
  parmdata *p = (parmdata *)v;
  ReadPARM *rp = p->rp;
  int i,j=0;
  int numbonds = rp->get_parm7_nbonds();
  p->from = (int *)malloc(numbonds*sizeof(int));
  p->to = (int *)malloc(numbonds*sizeof(int));
  for (i=0; i<numbonds; i++) {
   int a1,a2;
    rp->get_parm7_bond(i, (&a1)-i, (&a2)-i);
    if ( a1 <= p->natoms && a2 <= p->natoms) {
      p->from[j] = a1;
      p->to[j] =a2;
      j++;
    } else {
      printf("skipping bond (%d %d)\n",a1,a2); 
    }
  }
  *nbonds =j;
  *fromptr = p->from;
  *toptr = p->to;
  // XXX amber box info not supported in the API
  return MOLFILE_SUCCESS;
}

static void close_parm7_read(void *mydata) {
  parmdata *p = (parmdata *)mydata;
  p->rp->close_parm7_file(p->parm);
  if (p->from) free(p->from);
  if (p->to) free(p->to);
  delete p->rp;
}
 
/*
 * Initialization stuff down here
 */

static molfile_plugin_t parm7plugin = {
  vmdplugin_ABIVERSION,          // ABI Version
  MOLFILE_PLUGIN_TYPE,           // type of plugin
  "parm7",                       // name of plugin
  "Brian Bennion, Justin Gullingsrud, John E. Stone", // authors
  0,                             // major version
  4,                             // minor version
  VMDPLUGIN_THREADUNSAFE,        // is not reentrant
  "parm7",                       // filename extension
  open_parm7_read,        
  read_parm7_structure,  
  read_parm7_bonds,
  0,                             // read_next_timestep
  close_parm7_read,     
  0,
  0,
  0,
  0,
};

int VMDPLUGIN_init(){
  return VMDPLUGIN_SUCCESS;
}
int VMDPLUGIN_fini(){
  return VMDPLUGIN_SUCCESS;
}
int VMDPLUGIN_register(void *v, vmdplugin_register_cb cb) {
  (*cb)(v,(vmdplugin_t *)&parm7plugin);
  return VMDPLUGIN_SUCCESS;
}
