/***************************************************************************
 *cr
 *cr            (C) Copyright 1995-2002 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: vmdplugin.h,v $
 *      $Author: justin $       $Locker:  $             $State: Exp $
 *      $Revision: 1.10 $       $Date: 2003/03/27 17:08:14 $
 *
 ***************************************************************************/

/*
 * This header must be included by every VMD plugin library.  It defines the
 * API for every plugin so that VMD can organize the plugins it finds.  
 */

#ifndef VMD_PLUGIN_H
#define VMD_PLUGIN_H


/* Preprocessor tricks to make it easier for us to redefine the names of
 * functions when building static plugins.
 */
#if !defined(VMDPLUGIN)
#define VMDPLUGIN vmdplugin
#endif
#define xcat(x, y) cat(x, y)
#define cat(x, y) x ## y 
#define VMDPLUGIN_register     xcat(VMDPLUGIN, _register)
#define VMDPLUGIN_register_tcl xcat(VMDPLUGIN, _register_tcl)
#define VMDPLUGIN_init         xcat(VMDPLUGIN, _init)
#define VMDPLUGIN_fini         xcat(VMDPLUGIN, _fini)

#if (defined(WIN32) ) 

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#ifdef VMDPLUGIN_EXPORTS
/* only define DllMain for plugins, not in VMD... */
BOOL APIENTRY DllMain( HANDLE hModule,
                       DWORD ul_reason_for_call,
                       LPVOID lpReserved
                     )
{
  return TRUE;
}
#define VMDPLUGIN_API __declspec(dllexport)
#else
#define VMDPLUGIN_API __declspec(dllimport)
#endif

#else
#define VMDPLUGIN_API 
#endif

#ifdef __cplusplus
#define VMDPLUGIN_EXTERN extern "C" VMDPLUGIN_API
#else
#define VMDPLUGIN_EXTERN extern VMDPLUGIN_API
#endif  /* __cplusplus */


/* Plugin API starts here */


/* 
 * Init routine: called the first time the library is loaded by the 
 * application and before any other API functions are referenced.
 * Return 0 on success.
 */
VMDPLUGIN_EXTERN int VMDPLUGIN_init(void);

/*
 * Define a header for every plugin type; this header should be placed
 * at the top of every plugin API definition so that it can be treated
 * as a subtype of the base plugin type.
 *
 * abiversion: Defines the ABI for the base plugin type (not for other plugins)
 * type: A string descriptor of the plugin type.
 * name: A name for the plugin.
 * author: A string identifier, possibly including newlines.
 * Major and minor version.  
 * is_reentrant: Whether this library can be run concurrently with itself.
 */

#define vmdplugin_HEAD \
  int abiversion; \
  const char *type; \
  const char *name; \
  const char *author; \
  int majorv; \
  int minorv; \
  int is_reentrant; 

typedef struct {
  vmdplugin_HEAD
} vmdplugin_t;

/*
 * Use this to initialize the abiversion member of each plugin
 */
#define vmdplugin_ABIVERSION 2

/* 
 * Use this to mark a plugin as being thread safe or not at registration time
 */
#define VMDPLUGIN_THREADUNSAFE 0
#define VMDPLUGIN_THREADSAFE   1

/* 
 * Error return codes for use in the plugin registration and init functions
 */
#define VMDPLUGIN_SUCCESS      0
#define VMDPLUGIN_ERROR       -1

/*
 * register: Allow the library to register plugins with the application.
 * The callback should be called using the passed-in void pointer, which
 * should not be interpreted in any way by the library.  Each vmdplugin_t
 * pointer passed to the application should point to statically-allocated
 * or heap-allocated memory and should never be later modified by the plugin.
 * Applications must be permitted to retain only a copy of the the plugin
 * pointer, without making any deep copy of the items in the struct.
 */

typedef int (*vmdplugin_register_cb)(void *, vmdplugin_t *);

VMDPLUGIN_EXTERN int VMDPLUGIN_register(void *, vmdplugin_register_cb);

/*
 * register_tcl: Allow the library to register Tcl extensions.  
 * This API is optional; if found by dlopen, it will be called after first
 * calling init and register.  
 */

VMDPLUGIN_EXTERN int VMDPLUGIN_register_tcl(void *, void *tcl_interp, 
    vmdplugin_register_cb);

/*
 * Called when the application will no longer use any plugins in the
 * library.  
 */
VMDPLUGIN_EXTERN int VMDPLUGIN_fini(void);

#endif   /* VMD_PLUGIN_H */
