#!/bin/bash

# Launch multi-GPU benchmarks on TCB surtur
# (HGX-A100: 8x A100-SXM4-40GB, NVSwitch, 2x AMD EPYC 7742 64-Core Processor)
#
# See comments in run_gpuoff_nve.sh

# set to NAMD binary
NAMD=/Projects/dhardy/namd_builds/NAMD_3.0b6_Linux-x86_64-multicore-CUDA/namd3

echo STMV NPT GPU-offload on 1 GPU
#$NAMD +p8 +setcpuaffinity +devices 0 stmv_gpuoff_npt.namd |& tee out_stmv_gpuoff_npt_1gpu.log
$NAMD +p16 +pemap 0-15 +devices 0 stmv_gpuoff_npt.namd |& tee out_stmv_gpuoff_npt_1gpu.log

echo STMV NPT GPU-offload on 2 GPUs
#$NAMD +p16 +setcpuaffinity +devices 0,1 stmv_gpuoff_npt.namd |& tee out_stmv_gpuoff_npt_2.log
$NAMD +p32 +pemap 0-15,64-79 +devices 0,4 stmv_gpuoff_npt.namd |& tee out_stmv_gpuoff_npt_2gpu.log

echo STMV NPT GPU-offload on 4 GPUs
#$NAMD +p32 +setcpuaffinity +devices 0,1,2,3 stmv_gpuoff_npt.namd |& tee out_stmv_gpuoff_npt_4.log
$NAMD +p64 +pemap 0-15,64-79,32-47,96-111 +devices 0,4,2,6 stmv_gpuoff_npt.namd |& tee out_stmv_gpuoff_npt_4gpu.log

echo STMV NPT GPU-offload on 8 GPUs
#$NAMD +p64 +setcpuaffinity +devices 0,1,2,3,4,5,6,7 stmv_gpuoff_npt.namd |& tee out_stmv_gpuoff_npt_8.log
#
# XXX see comments from run_gpuoff_nve.sh
#
$NAMD +p64 +pemap 0-7,64-71,32-39,96-103,16-23,80-87,48-55,112-119 +devices 0,4,2,6,1,5,3,7 stmv_gpuoff_npt.namd |& tee out_stmv_gpuoff_npt_8gpu.log

