//
// The extended adaptive biasing force method has been contributed to NAMD by the following authors:
//
//    Haohao Fu and Christophe Chipot
//    Laboratoire International Associ\'e
//    Centre National de la Recherche Scientifique et University of Illinois at Urbana--Champaign
//    Unit\'e Mixte de Recherche No. 7565, Universit\'e de Lorraine
//    B.P. 70239, 54506 Vand\oe uvre-ls-Nancy cedex, France
//
// Copyright 2016, Centre National de la Recherche Scientifique
//

#ifndef EABF_H
#define EABF_H

#include <iostream>
#include <string>
#include <sstream>
#include <vector>
class ofstream_namd;

class eABF
{
public:
	eABF() {}
	eABF(const std::string& _outputfile,
		const int _outputfreq,
		const bool _restart, const std::string& _inputfile,
		const bool _outputgrad, const int _gradfreq, const double _temperature):
		outputfile(_outputfile), outputfreq(_outputfreq), restart(_restart), inputfile(_inputfile),
		outputgrad(_outputgrad), gradfreq(_gradfreq), temperature(_temperature)
	{}
	virtual ~eABF() {}

	// called by colvar each step, update the sampling point
	virtual bool update(const std::string&) = 0;

	// merge another file, used when reading another file
	bool mergefile(const std::string& inputname, const std::string& outputname)
	{
		this->inputfile = inputname;
		this->readfile();
		std::string temp = this->outputfile;
		this->outputfile = outputname;
		this->writefile();
		this->calpmf();
		this->outputfile = temp;
		return true;
	}

	// which coloum in the string provided by colvar is used
    bool setcolumn(std::vector<int> col)
	{
		this->col = col;
		return true;
	}

protected:
	// the colvar setting
	////////////////////////////////////////////////
	std::vector<double> lowerboundary;
	std::vector<double> upperboundary;
	std::vector<double> width;
	////////////////////////////////////////////////

	// the restart (output) file generated by parseABF
	std::string outputfile;

	// the frequency writing a restart file
	int outputfreq;

	// whether restart
	bool restart;

	// the restart input file
	std::string inputfile;

	// whether output gradient and pmf
	bool outputgrad;

	// the frequency writing grad and pmf file
	int gradfreq;

	// the temperature of simulation
	double temperature;

	// internal variables
	///////////////////////////////////////////////////////
	std::vector<int> max;        // the max index of the RC
	std::vector<int> min;        // the min index of the RC
	std::vector<int> bins;     // the number of bins

	std::vector<double> krestr; // force constant

	////////////////////////////////////////////////////////
	//    need to be defined
	////////////////////////////////////////////////////////
	// countall; // the distribution of samples, needed for eABF
	// sumx; // the sum of x in each bin, needed for eABF
	// sumx2; // the sum of x^2, needed for eABF
	// county; // the distribution in each bin, needed for eABF
	int line; // the number of non-zero countall

	std::vector<int> col;    // the column read by the program
	//////////////////////////////////////////////////////////

	// initialize the variables
	virtual bool initialize() = 0;

	// read variables from a restart file
	virtual bool readfile() = 0;

	// write restart file
	virtual bool writefile() const = 0;

	// write the head of the pmf file
	virtual bool writehead(ofstream_namd&) const = 0;

	// calculate grad and pmf
	virtual bool calpmf() const = 0;

};

#endif // EABF_H
