/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.pop3;

import com.sun.mail.pop3.Response;
import com.sun.mail.pop3.SharedByteArrayOutputStream;
import com.sun.mail.pop3.Status;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.SocketFetcher;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Properties;
import java.util.StringTokenizer;

class Protocol {
    private Socket socket;
    private DataInputStream input;
    private PrintWriter output;
    private static final int POP3_PORT = 110;
    private static final String CRLF = "\r\n";
    private boolean debug = false;
    private PrintStream out;

    Protocol(String string, int n, boolean bl, PrintStream printStream, Properties properties, String string2) throws IOException {
        Response response;
        this.debug = bl;
        this.out = printStream;
        try {
            if (n == -1) {
                n = 110;
            }
            if (bl) {
                printStream.println("DEBUG POP3: connecting to host \"" + string + "\", port " + n);
            }
            this.socket = SocketFetcher.getSocket((String)string, (int)n, (Properties)properties, (String)string2);
            this.input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.output = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "iso-8859-1")));
            response = this.simpleCommand(null);
        }
        catch (IOException iOException) {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {}
            throw iOException;
        }
        if (!response.ok) {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {}
            throw new IOException("Connect failed");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.socket != null) {
            this.quit();
        }
    }

    synchronized String login(String string, String string2) throws IOException {
        Response response = this.simpleCommand("USER " + string);
        if (!response.ok) {
            if (response.data != null) {
                return response.data;
            }
            return "USER command failed";
        }
        response = this.simpleCommand("PASS " + string2);
        if (!response.ok) {
            if (response.data != null) {
                return response.data;
            }
            return "login failed";
        }
        return null;
    }

    synchronized boolean quit() throws IOException {
        boolean bl = false;
        try {
            Response response = this.simpleCommand("QUIT");
            bl = response.ok;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {
                this.socket.close();
            }
            finally {
                Object v0 = null;
            }
        }
        Object var3_4 = null;
        try {
            this.socket.close();
        }
        finally {
            Object v1 = null;
        }
    }

    synchronized Status stat() throws IOException {
        Status status;
        block2: {
            Response response = this.simpleCommand("STAT");
            status = new Status();
            if (!response.ok || response.data == null) break block2;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(response.data);
                status.total = Integer.parseInt(stringTokenizer.nextToken());
                status.size = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {}
        }
        return status;
    }

    synchronized int list(int n) throws IOException {
        int n2;
        block2: {
            Response response = this.simpleCommand("LIST " + n);
            n2 = -1;
            if (!response.ok || response.data == null) break block2;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(response.data);
                stringTokenizer.nextToken();
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {}
        }
        return n2;
    }

    synchronized InputStream retr(int n, int n2) throws IOException {
        Response response = this.multilineCommand("RETR " + n, n2);
        return response.bytes;
    }

    synchronized InputStream top(int n, int n2) throws IOException {
        Response response = this.multilineCommand("TOP " + n + " " + n2, 0);
        return response.bytes;
    }

    synchronized boolean dele(int n) throws IOException {
        Response response = this.simpleCommand("DELE " + n);
        return response.ok;
    }

    synchronized String uidl(int n) throws IOException {
        Response response = this.simpleCommand("UIDL " + n);
        if (!response.ok) {
            return null;
        }
        int n2 = response.data.indexOf(32);
        if (n2 > 0) {
            return response.data.substring(n2 + 1);
        }
        return null;
    }

    synchronized boolean uidl(String[] stringArray) throws IOException {
        Response response = this.multilineCommand("UIDL", 15 * stringArray.length);
        if (!response.ok) {
            return false;
        }
        LineInputStream lineInputStream = new LineInputStream(response.bytes);
        String string = null;
        while ((string = lineInputStream.readLine()) != null) {
            int n;
            int n2 = string.indexOf(32);
            if (n2 < 1 || n2 >= string.length() || (n = Integer.parseInt(string.substring(0, n2))) <= 0 || n > stringArray.length) continue;
            stringArray[n - 1] = string.substring(n2 + 1);
        }
        return true;
    }

    synchronized boolean noop() throws IOException {
        Response response = this.simpleCommand("NOOP");
        return response.ok;
    }

    synchronized boolean rset() throws IOException {
        Response response = this.simpleCommand("RSET");
        return response.ok;
    }

    private Response simpleCommand(String string) throws IOException {
        String string2;
        if (this.socket == null) {
            throw new IOException("Folder is closed");
        }
        if (string != null) {
            if (this.debug) {
                this.out.println("C: " + string);
            }
            string = String.valueOf(string) + CRLF;
            this.output.print(string);
            this.output.flush();
        }
        if ((string2 = this.input.readLine()) == null) {
            if (this.debug) {
                this.out.println("S: EOF");
            }
            throw new EOFException("EOF on socket");
        }
        if (this.debug) {
            this.out.println("S: " + string2);
        }
        Response response = new Response();
        if (string2.startsWith("+OK")) {
            response.ok = true;
        } else if (string2.startsWith("-ERR")) {
            response.ok = false;
        } else {
            throw new IOException("Unexpected response: " + string2);
        }
        int n = string2.indexOf(32);
        if (n >= 0) {
            response.data = string2.substring(n + 1);
        }
        return response;
    }

    private Response multilineCommand(String string, int n) throws IOException {
        int n2;
        Response response = this.simpleCommand(string);
        if (!response.ok) {
            return response;
        }
        SharedByteArrayOutputStream sharedByteArrayOutputStream = new SharedByteArrayOutputStream(n);
        int n3 = 10;
        while ((n2 = this.input.read()) >= 0) {
            if (n3 == 10 && n2 == 46 && (n2 = this.input.read()) == 13) {
                this.input.read();
                break;
            }
            sharedByteArrayOutputStream.write(n2);
            if (this.debug) {
                this.out.write(n2);
            }
            n3 = n2;
        }
        if (n2 < 0) {
            throw new EOFException("EOF on socket");
        }
        response.bytes = sharedByteArrayOutputStream.toStream();
        return response;
    }
}

