#Usage: mdodelmaker mdff -pdb <input pdb file> -density <input density file>  -res <resolution of density in Angstroms> ?options?
#Options:
#  -workdir    <working/project directory for job> (default: /bph/theodata2/penpes/A_Modul_2018/Fold_insertion/test/mdff-workdir)>
#  -jobname    <name prefix for job> (default: taken from -model) 
#  -fixed      <atomselect text for fixed atoms> (default: none) 
#  -gscale     <grid scaling factor for fitting forces> (default: 0.3) 
#  -minsteps   <number of minimization steps> (default: 200) 
#  -numsteps   <number of simulation steps> (default: 10000) 
#  -chseg      <file containing lines of desired 'name' 'chain' 'segname'> (Default: from input pdb)
#  -topfiles   <list of topology files to use>(Default: /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmtop1.2/top_all36_prot.rtf /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmtop1.2/top_all36_lipid.rtf /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmtop1.2/top_all36_na.rtf /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmtop1.2/top_all36_carb.rtf /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmtop1.2/top_all36_cgenff.rtf /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmtop1.2/toppar_all36_carb_glycopeptide.str /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmtop1.2/toppar_water_ions_namd.str) 
#  -parfiles   <list of parameter files to use>(Default: /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmpar1.4/par_all36_prot.prm /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmpar1.4/par_all36_lipid.prm /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmpar1.4/par_all36_na.prm /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmpar1.4/par_all36_carb.prm /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmpar1.4/par_all36_cgenff.prm /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmpar1.4/toppar_all36_carb_glycopeptide.str /bph/app/vmd/1.9.4/lib/plugins/noarch/tcl/readcharmmpar1.4/toppar_water_ions_namd.str) 
#  -dcdfreq    <frequencey of dcd output>(Default: 100) 
#  -namdargs   <arguments to pass to namd> (default: none)
#  -ss         <secondary structure restraint file> (default: auto-generated)
#  -cis        <cispeptide restraint file> (default: auto-generated)
#  -chir       <chirality restraint file> (default: auto-generated)
#  -extrab     <list of additional extrabonds files> (default: none)

set DENS_LOW rpn11_s1_lowres_3_7.7_moved_density.mrc
set NUMSTEPS 20000
set MINSTEPS 1000
set INPUT rpn11_s1_lowres_aligned


modelmaker mdff -pdb ${INPUT}.pdb -workdir mdff_step1 -fixed "none" -density ${DENS_LOW} -res 8 -gscale 0.3 -minsteps ${MINSTEPS} -numsteps ${NUMSTEPS} -namdargs "+p2" -jobname rpn11_mdff_lowres  -topfiles {/home/master/A_Modul_2018/MDFF_Low_Resolution/top_all27_prot_na.rtf /home/master/A_Modul_2018/MDFF_Low_Resolution/toppar_all27_na_nad_ppi.str} -parfiles {/home/master/A_Modul_2018/MDFF_Low_Resolution/par_all27_prot_lipid_na.inp}





