#Usage: modelmaker abinitio -model <full length template pdb> -fragfiles <list of fragment files>  -sel <list of atomselection texts with selections to fold> -anchor <atomselection text for anchor residue for coordinate restraints>  ?options?
#Options:
#  -jobname    <name prefix for job> (default: taken from -model)> 
#  -workdir    <working/project directory for job> (default: /bph/theodata2/penpes/A_Modul_2018/Fold_insertion/test/workdir)>
#  -nstruct    <number of structures to predict> (default: 5000)> 
#  -testrun    <test run flag (0 or 1)> (default: 0)> 
#  -np         <Number of processors to use. MPI version only> 

#define variables
set start "18"
set end "306"
set subunit "rpn11"
set chainID "V"
set segNAME "RN11"
set FastaId "P43588"
set Mol "rpn11_start_structure_18-288"

mol new ${Mol}.pdb

#cut fasta 
modelmaker seqsub -i ${FastaId}.fasta -o ${subunit}_${start}-${end}.fasta -start $start -end $end


#Creating the full-length-model
modelmaker full_length_model -template ${Mol}.pdb -fragfiles {rpn11_18-306.frag9 rpn11_18-306.frag3} -fasta ${subunit}_${start}-${end}.fasta -resstart ${start}
mv rpn11_start_structure_18-288_full_length.pdb rpn11_start_structure_18-306_full_length.pdb


#Fold protein termini
modelmaker abinitio -np 2 -model rpn11_start_structure_18-306_full_length.pdb -jobname ${subunit}_${start}-${end} -anchor "resid 280" -fragfiles {{rpn11_18-306.frag9 rpn11_18-306.frag3}} -sel "resid 288 to 306" -nstruct 2

modelmaker analyze -model rpn11_start_structure_18-306_full_length.pdb -jobname ${subunit}_${start}-${end} -template rpn11_start_structure_18-306_full_length.pdb  -nstruct 2 -align_template "resid 288 to 306" -comps {{ss 288 306 "V"}}
exit

