#Usage: modelmaker abinitio -model <full length template pdb> -fragfiles <list of fragment files>  -sel <list of atomselection texts with selections to fold> -anchor <atomselection text for anchor residue for coordinate restraints>  ?options?
#Options:
#  -jobname    <name prefix for job> (default: taken from -model)> 
#  -workdir    <working/project directory for job> (default: /bph/theodata2/penpes/A_Modul_2018/Fold_insertion/test/workdir)>
#  -nstruct    <number of structures to predict> (default: 5000)> 
#  -testrun    <test run flag (0 or 1)> (default: 0)> 
#  -np         <Number of processors to use. MPI version only> 

#define variables
set start "200"
set end "271"
set subunit "rpn11"
set chainID "V"
set segNAME "RN11"
set FastaId "P43588"

#load the pdb structure into vmd
set MOL "rpn11_start_structure_18-200_271-306.pdb"
mol new $MOL


#cut fasta 
modelmaker seqsub -i ${FastaId}.fasta -o ${subunit}_18-306.fasta -start 18 -end 306


#Creating the full length model 
modelmaker full_length_model -template ${MOL} -fragfiles {rpn11_18-306.frag9 rpn11_18-306.frag3} -fasta ${subunit}_18-306.fasta -resstart 18
mv rpn11_start_structure_18-200_271-306_full_length.pdb rpn11_start_structure_18-306_full_length.pdb 
exit
