
# initial structure (properly aligned to map)
set molInitial [mol new rpn11_s1_lowres.pdb waitfor all]
 
# target structure (where you want DX to align)
set molTarget [mol new rpn11_s1.pdb waitfor all]
 
# Let's move the target structure to the reference frame of the
# ribosome in a water box.
set selInitial [atomselect $molInitial all]
set selTarget [atomselect $molTarget all]
set A [measure fit $selInitial $selTarget]


#extract rotation 
#set rotMatrix {}
#lappend rotMatrix [lrange [lindex $A 0] 0 2]
#lappend rotMatrix [lrange [lindex $A 1] 0 2]
#lappend rotMatrix [lrange [lindex $A 2] 0 2]

#extract translation
set transVector {}
lappend transVector [lindex [lindex $A 0] 3]
lappend transVector [lindex [lindex $A 1] 3]
lappend transVector [lindex [lindex $A 2] 3]


#change to origin and delta from the header of your .DX file
set origin [list 89.5 279.5 258.5]
set delta0  [list 1 0 0]
set delta1  [list 0 1 0]
set delta2  [list 0 0 1]

#apply translation
set newOrigin [vecadd [vectrans $A $origin] $transVector]
set newDelta0 [vectrans $A $delta0]
set newDelta1 [vectrans $A $delta1]
set newDelta2 [vectrans $A $delta2]

#output new origin and delta, copy this into you .DX file
puts "origin $newOrigin"
puts "delta $newDelta0"
puts "delta $newDelta1"
puts "delta $newDelta2"

quit
