#Usage: modelmaker abinitio -model <full length template pdb> -fragfiles <list of fragment files>  -sel <list of atomselection texts with selections to fold> -anchor <atomselection text for anchor residue for coordinate restraints>  ?options?
#Options:
#  -jobname    <name prefix for job> (default: taken from -model)> 
#  -workdir    <working/project directory for job> (default: /bph/theodata2/penpes/A_Modul_2018/Fold_insertion/test/workdir)>
#  -nstruct    <number of structures to predict> (default: 5000)> 
#  -testrun    <test run flag (0 or 1)> (default: 0)> 
#  -np         <Number of processors to use. MPI version only> 


set start "397"
set end "405"
set MOL "3h4m_3H43_model_10.chainA.segna_full_length"
set chainID "A"
#set segNAME "RPT6"
#set FastaID "RT6_PROTEASOM"


modelmaker abinitio -np 4 -model ${MOL}.pdb -jobname beginning -anchor "resid 100" -fragfiles {{rtp6_yeast.frag9 rtp6_yeast.frag3}} -sel "resid 1 to 52" -nstruct 4

modelmaker analyze -model ${MOL}.pdb -jobname beginning -template ${MOL}.pdb -nstruct 4 -align_template "resid 55 to 120" -comps {{ss 1 52 "A"}}


