#proc from: https://github.com/tonigi/vmd_extensions
proc renumber { sel start } {
	if { [$sel num] == 0 } {
		puts "Error in renumber: empty selection!"
		return
	}
	set oresid [ $sel get resid ]
	set delta [ expr $start - [ lindex $oresid 0] ]
	set nresid { }
	foreach r $oresid {
		lappend nresid [ expr $r + $delta ]
	}
	$sel set resid $nresid
}
set mols [list 3h4m_model_10]
set newstart 136
foreach mol $mols {
	mol delete all
	mol new $mol.pdb
	renumber [atomselect top all] $newstart
	[atomselect top all] writepdb $mol-numb.pdb
}

quit
