#Usage: modelmaker refine -model <full length template pdb>  -sel <list of atomselection texts with selections to fold> -anchor <anchor residue for coordinate restraints>  -density <density file to refine against in .mrc format> -res <resolution of the density in Angstroms>  ?options?
#Options:
#  -mode       <refinement mode (backbone, sidechain, or cartesian> (default: backbone)
#  -jobname    <name prefix for job> (default: taken from -model) 
#  -workdir    <working/project directory for job> (default: /bph/theodata2/penpes/A_Modul_2018/Fold_insertion/test/workdir)
#  -nstruct    <number of structures to predict> (default: 5000) 
#  -bestN      <number of structures with best scores to save> (default: same as -nstruct) 
#  -score      <Rosetta density score; lower values indicate lower weight> (default: -0.3) 
#  -np         <Number of processors to use. MPI version only>

set TOPPATH /home/master/A_Modul_2018/MDFF_Low_Resolution/
set NUMSTEPS 1000
set NUMSTRUCT 2
set ANCHOR "resid 200"
set MOL rpn11_s1
set DENS_HIGH "rpn11_s1_3_4.2_density.mrc"
set MOL "rpn11_s1.pdb"
set SELE_BB "resid 288 to 306"
set ANCHOR "resid 200"


 modelmaker refine -mode backbone -model ${MOL} -workdir refine_bb_step1 -anchor ${ANCHOR}  -sel [list $SELE_BB] -density ${DENS_HIGH} -res 8 -nstruct $NUMSTRUCT -bestN 1 -jobname ${JOBNAME} -score -0.3 -np 2


exit
