#Usage: modelmaker insertion -model <full length template pdb> -fragfiles <list of fragment files>  -sel <list of atomselection texts with selections to fold> -fasta <fasta file>  ?options?
#Options:
#  -jobname    <name prefix for job> (default: taken from -model)> 
#  -nstruct    <number of structures to predict> (default: 5000)> 
#  -workdir    <working/project directory for job> (default: /bph/theodata2/penpes/A_Modul_2018/Fold_insertion/test/workdir)>
#  -np         <Number of processors to use. MPI version only> 

#define variables
set start "128"
set end "135"
#set subunit "rpn11"
set chainID "A"
set segNAME "RPT6"
set FastaID "RT6_PROTEASOM"
set MOL "3h4m_3H43_model_10.chainA.segna_full_length.pdb"
mol new $MOL

##Fold insertion
modelmaker insertion -np 4 -model ${MOL}  -jobname insertion -fasta ${FastaID}.fasta  -fragfiles {rtp6_yeast.frag9 rtp6_yeast.frag3} -sel "resid 128 to 135" -nstruct 4
#
##Analyze 
modelmaker analyze -insertion yes -model ${MOL} -jobname insertion -template ${MOL} -nstruct 4 -align_template "resid 55 to 120" -comps {{ss 128 to 135 "A"} {cluster 128 135 "A" 4}}
#
exit
#
