#!/bin/bash

cat ../../run/centers.tcl ../0-colvars/colvars.txt | \
awk -v n=1024 -v k=250 -v K=0.25 '
function acos(o) {
    if (o>=1) {
	return 0
    } else if (o<=-1) {
	return 4*atan2(0.5,0.5)
    } else {
	return atan2(-o,sqrt(1-o*o))+2*atan2(0.5,0.5)
    }
}{
    if (NR<=n) {
	z1[NR]=$16
	z2[NR]=$26
	z3[NR]=$36
	split($0,C,"(")
	for (j=1;j<=3;j++) {
	    split(C[j+2],D)
	    for (l=1;l<=4;l++) q[NR,j,l]=D[2*l-1]
	}
    } else {
	printf "%d %d",$2,$1
	for (i=1;i<=n;i++) {
	    u=0.5*K*($3-z1[i])*($3-z1[i])
	    u+=0.5*K*($4-z2[i])*($4-z2[i])
	    u+=0.5*K*($5-z3[i])*($5-z3[i])
	    for (j=1;j<=3;j++) {
		co=0
		for (l=1;l<=4;l++) co+=q[i,j,l]*$(4*j+l+1)
		o=acos(co)
		u+=0.5*k*o*o
	    }
	    printf " %f",u
	}
	printf "\n"
    }
}' > pot.txt
