#!/bin/bash

# i is the replica index (I have 1024 replicas)
# j is the job/run index job1, job2, etc (assuming job0 is for relaxation and not good for analysis)
# I choose to use the data from every 20 ps ($1%10000==0)

rm colvars.txt
for i in `seq 0 1023`
do
for j in `seq 1 2`
do
    grep -v "#" ../../output/$i/us.job$j.$i.colvars.traj | uniq | \
    awk '$1%10000==0{printf "%s %s %s %s",$1,$11,$21,$31;for(i=0;i<=2;i++)printf " %s %s %s %s",$(10*i+3),$(10*i+5),$(10*i+7),$(10*i+9);printf"\n"}' > traj.txt
    cat ../../output/$i/us.job$j.$i.history | awk '$1%10000==0{print $1,$2}' > hist.txt
    join --nocheck-order hist.txt traj.txt >> colvars.txt
done
done
