from sys import exit
from prody import *
import numpy as np
import scipy as sp
from math import exp,log,sqrt
from random import *

#dt=1 # time intervals

pseudobeta=1 # acceprance rate
noiseR=0.1 # noise applied to R
noiseP=0 # noise applied to P
smooth=0.001 # smoothness imposed on D
iterations=100000 # Number of MC iterations

N=parseArray('N.txt')
n=N.shape[0]
m=N.shape[1]
if n!=m:
    exit("Square matrix is required")

P=parseArray('P0.txt')
m=P.shape[0]
if n!=m:
    exit("P and N are inconsistent")

R=np.zeros((n,n))
for i in range(n):
    for j in range(n):
	if i==j+1 or j==i+1:
	    R[i,j]=P[i]*(N[i,j]+N[j,i])/(N[i,i]*P[j]+N[j,j]*P[i])
	else:
	    R[i,i]=0
	    for k in range(i-1,i+2):
		if (i!=k and k<n):
		    R[i,i]-=P[k]*(N[k,i]+N[i,k])/(N[i,i]*P[k]+N[k,k]*P[i])

writeArray("R0.txt",R,format="%s")
lmda=np.linalg.eigvals(R)
writeArray("lmda0.txt",lmda,format="%s")
r=sp.linalg.expm2(R)
writeArray("r0.txt",r,format="%s")
D=np.zeros((n-1))
for i in range(n-1):
	D[i]=R[i,i+1]*sqrt(P[i+1]/P[i])
writeArray("D0.txt",D,format="%s")


logl=0
for i in range(n):
    for j in range(n):
	if N[i,j]*r[i,j]>0:
	    logl+=log(r[i,j])*N[i,j]
if smooth>0:
    for i in range(n-2):
	logl-=(D[i]-D[i+1])**2/(2*smooth**2)

print 0,logl,1

seed()

for t in range(1,iterations):
    i=randint(0,n-1)
    if (t%2==0 or noiseP==0):
	j=n
	while j>=n or j<0:
	    j=i+1-2*randint(0,1)
	dr=-R[i,j]
	while R[i,j]+dr<=0:
	    dr=(random()-0.5)*noiseR
	R[i,j]+=dr
	R[j,i]+=dr*P[j]/P[i]
	R[i,i]-=dr*P[j]/P[i]
	R[j,j]-=dr
    else:
    	dp=(random()-0.5)*noiseP
    	for j in range(n):
    	    P[j]/=(1+dp*P[i])
    	P[i]*=(1+dp)
	if (i<n-1):
	    R[i+1,i+1]+=R[i,i+1]*dp
	    R[i,i+1]*=1+dp
	if (i>0):
	    R[i-1,i-1]+=R[i,i-1]*dp
	    R[i,i-1]*=1+dp

    r=sp.linalg.expm2(R)
    loglt=0
    for ii in range(n):
	for jj in range(n):
	    if N[ii,jj]*r[ii,jj]>0:
		loglt+=log(r[ii,jj])*N[ii,jj]
    if smooth>0:
	for ii in range(n-1):
	    D[ii]=R[ii,ii+1]*sqrt(P[ii+1]/P[ii])
	for ii in range(n-2):
	    loglt-=(D[ii]-D[ii+1])**2/(2*smooth**2)

    if loglt<logl and random()>exp(pseudobeta*(loglt-logl)):
	if (t%2==0 or noiseP==0):
	    R[i,j]-=dr
	    R[j,i]-=dr*P[j]/P[i]
	    R[i,i]+=dr*P[j]/P[i]
	    R[j,j]+=dr
	else:
    	    P[i]/=(1+dp)
    	    for j in range(n):
    		P[j]*=(1+dp*P[i])
	    if (i<n-1):
		R[i,i+1]/=1+dp
		R[i+1,i+1]-=R[i,i+1]*dp
	    if (i>0):
		R[i,i-1]/=1+dp
		R[i-1,i-1]-=R[i,i-1]*dp
	print t,loglt,0
    else:
	logl=loglt
	print t,loglt,1
	    
writeArray("R.txt",R,format="%s")
lmda=np.linalg.eigvals(R)
writeArray("lmda.txt",lmda,format="%s")
writeArray("r.txt",r,format="%s")

for i in range(n-1):
	D[i]=R[i,i+1]*sqrt(P[i+1]/P[i])
writeArray("D.txt",D,format="%s")
writeArray("P.txt",P,format="%s")

exit("Done!")
